import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AppSamlAppSettingsConfig extends cdktf.TerraformMetaArguments {
    /**
     * Application ID.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml_app_settings.html#app_id AppSamlAppSettings#app_id}
     *
     * @stability stable
     */
    readonly appId: string;
    /**
     * Application settings in JSON format.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml_app_settings.html#settings AppSamlAppSettings#settings}
     *
     * @stability stable
     */
    readonly settings: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/app_saml_app_settings.html okta_app_saml_app_settings}.
 *
 * @stability stable
 */
export declare class AppSamlAppSettings extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/app_saml_app_settings.html okta_app_saml_app_settings} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AppSamlAppSettingsConfig);
    private _appId?;
    /**
     * @stability stable
     */
    get appId(): string;
    /**
     * @stability stable
     */
    set appId(value: string);
    /**
     * @stability stable
     */
    get appIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _settings?;
    /**
     * @stability stable
     */
    get settings(): string;
    /**
     * @stability stable
     */
    set settings(value: string);
    /**
     * @stability stable
     */
    get settingsInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
