import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AppSamlConfig extends cdktf.TerraformMetaArguments {
    /**
     * Custom error page URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#accessibility_error_redirect_url AppSaml#accessibility_error_redirect_url}
     *
     * @stability stable
     */
    readonly accessibilityErrorRedirectUrl?: string;
    /**
     * Custom login page URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#accessibility_login_redirect_url AppSaml#accessibility_login_redirect_url}
     *
     * @stability stable
     */
    readonly accessibilityLoginRedirectUrl?: string;
    /**
     * Enable self service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#accessibility_self_service AppSaml#accessibility_self_service}
     *
     * @stability stable
     */
    readonly accessibilitySelfService?: boolean | cdktf.IResolvable;
    /**
     * List of ACS endpoints for this SAML application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#acs_endpoints AppSaml#acs_endpoints}
     *
     * @stability stable
     */
    readonly acsEndpoints?: string[];
    /**
     * Application notes for admins.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#admin_note AppSaml#admin_note}
     *
     * @stability stable
     */
    readonly adminNote?: string;
    /**
     * Displays specific appLinks for the app.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#app_links_json AppSaml#app_links_json}
     *
     * @stability stable
     */
    readonly appLinksJson?: string;
    /**
     * Application settings in JSON format.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#app_settings_json AppSaml#app_settings_json}
     *
     * @stability stable
     */
    readonly appSettingsJson?: string;
    /**
     * Determines whether the SAML assertion is digitally signed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#assertion_signed AppSaml#assertion_signed}
     *
     * @stability stable
     */
    readonly assertionSigned?: boolean | cdktf.IResolvable;
    /**
     * Audience Restriction.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#audience AppSaml#audience}
     *
     * @stability stable
     */
    readonly audience?: string;
    /**
     * Identifies the SAML authentication context class for the assertion’s authentication statement.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#authn_context_class_ref AppSaml#authn_context_class_ref}
     *
     * @stability stable
     */
    readonly authnContextClassRef?: string;
    /**
     * Display auto submit toolbar.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#auto_submit_toolbar AppSaml#auto_submit_toolbar}
     *
     * @stability stable
     */
    readonly autoSubmitToolbar?: boolean | cdktf.IResolvable;
    /**
     * Identifies a specific application resource in an IDP initiated SSO scenario.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#default_relay_state AppSaml#default_relay_state}
     *
     * @stability stable
     */
    readonly defaultRelayState?: string;
    /**
     * Identifies the location where the SAML response is intended to be sent inside of the SAML assertion.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#destination AppSaml#destination}
     *
     * @stability stable
     */
    readonly destination?: string;
    /**
     * Determines the digest algorithm used to digitally sign the SAML assertion and response.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#digest_algorithm AppSaml#digest_algorithm}
     *
     * @stability stable
     */
    readonly digestAlgorithm?: string;
    /**
     * Application notes for end users.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#enduser_note AppSaml#enduser_note}
     *
     * @stability stable
     */
    readonly enduserNote?: string;
    /**
     * features to enable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#features AppSaml#features}
     *
     * @stability stable
     */
    readonly features?: string[];
    /**
     * Groups associated with the application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#groups AppSaml#groups}
     *
     * @stability stable
     */
    readonly groups?: string[];
    /**
     * Do not display application icon on mobile app.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#hide_ios AppSaml#hide_ios}
     *
     * @stability stable
     */
    readonly hideIos?: boolean | cdktf.IResolvable;
    /**
     * Do not display application icon to users.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#hide_web AppSaml#hide_web}
     *
     * @stability stable
     */
    readonly hideWeb?: boolean | cdktf.IResolvable;
    /**
     * Prompt user to re-authenticate if SP asks for it.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#honor_force_authn AppSaml#honor_force_authn}
     *
     * @stability stable
     */
    readonly honorForceAuthn?: boolean | cdktf.IResolvable;
    /**
     * SAML issuer ID.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#idp_issuer AppSaml#idp_issuer}
     *
     * @stability stable
     */
    readonly idpIssuer?: string;
    /**
     * *Early Access Property*. Enable Federation Broker Mode.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#implicit_assignment AppSaml#implicit_assignment}
     *
     * @stability stable
     */
    readonly implicitAssignment?: boolean | cdktf.IResolvable;
    /**
     * Saml Inline Hook setting.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#inline_hook_id AppSaml#inline_hook_id}
     *
     * @stability stable
     */
    readonly inlineHookId?: string;
    /**
     * Certificate name. This modulates the rotation of keys. New name == new key.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#key_name AppSaml#key_name}
     *
     * @stability stable
     */
    readonly keyName?: string;
    /**
     * Number of years the certificate is valid.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#key_years_valid AppSaml#key_years_valid}
     *
     * @stability stable
     */
    readonly keyYearsValid?: number;
    /**
     * Pretty name of app.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#label AppSaml#label}
     *
     * @stability stable
     */
    readonly label: string;
    /**
     * Local path to logo of the application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#logo AppSaml#logo}
     *
     * @stability stable
     */
    readonly logo?: string;
    /**
     * Name of preexisting SAML application. For instance 'slack'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#preconfigured_app AppSaml#preconfigured_app}
     *
     * @stability stable
     */
    readonly preconfiguredApp?: string;
    /**
     * The location where the app may present the SAML assertion.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#recipient AppSaml#recipient}
     *
     * @stability stable
     */
    readonly recipient?: string;
    /**
     * Denotes whether the request is compressed or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#request_compressed AppSaml#request_compressed}
     *
     * @stability stable
     */
    readonly requestCompressed?: boolean | cdktf.IResolvable;
    /**
     * Determines whether the SAML auth response message is digitally signed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#response_signed AppSaml#response_signed}
     *
     * @stability stable
     */
    readonly responseSigned?: boolean | cdktf.IResolvable;
    /**
     * SAML version for the app's sign-on mode.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#saml_version AppSaml#saml_version}
     *
     * @stability stable
     */
    readonly samlVersion?: string;
    /**
     * Signature algorithm used ot digitally sign the assertion and response.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#signature_algorithm AppSaml#signature_algorithm}
     *
     * @stability stable
     */
    readonly signatureAlgorithm?: string;
    /**
     * x509 encoded certificate that the Service Provider uses to sign Single Logout requests.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#single_logout_certificate AppSaml#single_logout_certificate}
     *
     * @stability stable
     */
    readonly singleLogoutCertificate?: string;
    /**
     * The issuer of the Service Provider that generates the Single Logout request.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#single_logout_issuer AppSaml#single_logout_issuer}
     *
     * @stability stable
     */
    readonly singleLogoutIssuer?: string;
    /**
     * The location where the logout response is sent.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#single_logout_url AppSaml#single_logout_url}
     *
     * @stability stable
     */
    readonly singleLogoutUrl?: string;
    /**
     * Ignore groups sync. This is a temporary solution until 'groups' field is supported in all the app-like resources.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#skip_groups AppSaml#skip_groups}
     *
     * @stability stable
     */
    readonly skipGroups?: boolean | cdktf.IResolvable;
    /**
     * Ignore users sync. This is a temporary solution until 'users' field is supported in all the app-like resources.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#skip_users AppSaml#skip_users}
     *
     * @stability stable
     */
    readonly skipUsers?: boolean | cdktf.IResolvable;
    /**
     * SAML SP issuer ID.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#sp_issuer AppSaml#sp_issuer}
     *
     * @stability stable
     */
    readonly spIssuer?: string;
    /**
     * Single Sign On URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#sso_url AppSaml#sso_url}
     *
     * @stability stable
     */
    readonly ssoUrl?: string;
    /**
     * Status of application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#status AppSaml#status}
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * Identifies the SAML processing rules.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#subject_name_id_format AppSaml#subject_name_id_format}
     *
     * @stability stable
     */
    readonly subjectNameIdFormat?: string;
    /**
     * Template for app user's username when a user is assigned to the app.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#subject_name_id_template AppSaml#subject_name_id_template}
     *
     * @stability stable
     */
    readonly subjectNameIdTemplate?: string;
    /**
     * Username template.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#user_name_template AppSaml#user_name_template}
     *
     * @stability stable
     */
    readonly userNameTemplate?: string;
    /**
     * Push username on update.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#user_name_template_push_status AppSaml#user_name_template_push_status}
     *
     * @stability stable
     */
    readonly userNameTemplatePushStatus?: string;
    /**
     * Username template suffix.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#user_name_template_suffix AppSaml#user_name_template_suffix}
     *
     * @stability stable
     */
    readonly userNameTemplateSuffix?: string;
    /**
     * Username template type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#user_name_template_type AppSaml#user_name_template_type}
     *
     * @stability stable
     */
    readonly userNameTemplateType?: string;
    /**
     * attribute_statements block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#attribute_statements AppSaml#attribute_statements}
     *
     * @stability stable
     */
    readonly attributeStatements?: AppSamlAttributeStatements[];
    /**
     * users block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#users AppSaml#users}
     *
     * @stability stable
     */
    readonly users?: AppSamlUsers[];
}
/**
 * @stability stable
 */
export interface AppSamlAttributeStatements {
    /**
     * Type of group attribute filter.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#filter_type AppSaml#filter_type}
     *
     * @stability stable
     */
    readonly filterType?: string;
    /**
     * Filter value to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#filter_value AppSaml#filter_value}
     *
     * @stability stable
     */
    readonly filterValue?: string;
    /**
     * The reference name of the attribute statement.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#name AppSaml#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The name format of the attribute.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#namespace AppSaml#namespace}
     *
     * @stability stable
     */
    readonly namespace?: string;
    /**
     * The type of attribute statements object.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#type AppSaml#type}
     *
     * @stability stable
     */
    readonly type?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#values AppSaml#values}.
     *
     * @stability stable
     */
    readonly values?: string[];
}
export declare function appSamlAttributeStatementsToTerraform(struct?: AppSamlAttributeStatements): any;
/**
 * @stability stable
 */
export interface AppSamlUsers {
    /**
     * User ID.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#id AppSaml#id}
     *
     * @stability stable
     */
    readonly id?: string;
    /**
     * Password for user application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#password AppSaml#password}
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * Username for user.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html#username AppSaml#username}
     *
     * @stability stable
     */
    readonly username?: string;
}
export declare function appSamlUsersToTerraform(struct?: AppSamlUsers): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html okta_app_saml}.
 *
 * @stability stable
 */
export declare class AppSaml extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/app_saml.html okta_app_saml} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AppSamlConfig);
    private _accessibilityErrorRedirectUrl?;
    /**
     * @stability stable
     */
    get accessibilityErrorRedirectUrl(): string;
    /**
     * @stability stable
     */
    set accessibilityErrorRedirectUrl(value: string);
    /**
     * @stability stable
     */
    resetAccessibilityErrorRedirectUrl(): void;
    /**
     * @stability stable
     */
    get accessibilityErrorRedirectUrlInput(): string | undefined;
    private _accessibilityLoginRedirectUrl?;
    /**
     * @stability stable
     */
    get accessibilityLoginRedirectUrl(): string;
    /**
     * @stability stable
     */
    set accessibilityLoginRedirectUrl(value: string);
    /**
     * @stability stable
     */
    resetAccessibilityLoginRedirectUrl(): void;
    /**
     * @stability stable
     */
    get accessibilityLoginRedirectUrlInput(): string | undefined;
    private _accessibilitySelfService?;
    /**
     * @stability stable
     */
    get accessibilitySelfService(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set accessibilitySelfService(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAccessibilitySelfService(): void;
    /**
     * @stability stable
     */
    get accessibilitySelfServiceInput(): boolean | cdktf.IResolvable | undefined;
    private _acsEndpoints?;
    /**
     * @stability stable
     */
    get acsEndpoints(): string[];
    /**
     * @stability stable
     */
    set acsEndpoints(value: string[]);
    /**
     * @stability stable
     */
    resetAcsEndpoints(): void;
    /**
     * @stability stable
     */
    get acsEndpointsInput(): string[] | undefined;
    private _adminNote?;
    /**
     * @stability stable
     */
    get adminNote(): string;
    /**
     * @stability stable
     */
    set adminNote(value: string);
    /**
     * @stability stable
     */
    resetAdminNote(): void;
    /**
     * @stability stable
     */
    get adminNoteInput(): string | undefined;
    private _appLinksJson?;
    /**
     * @stability stable
     */
    get appLinksJson(): string;
    /**
     * @stability stable
     */
    set appLinksJson(value: string);
    /**
     * @stability stable
     */
    resetAppLinksJson(): void;
    /**
     * @stability stable
     */
    get appLinksJsonInput(): string | undefined;
    private _appSettingsJson?;
    /**
     * @stability stable
     */
    get appSettingsJson(): string;
    /**
     * @stability stable
     */
    set appSettingsJson(value: string);
    /**
     * @stability stable
     */
    resetAppSettingsJson(): void;
    /**
     * @stability stable
     */
    get appSettingsJsonInput(): string | undefined;
    private _assertionSigned?;
    /**
     * @stability stable
     */
    get assertionSigned(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set assertionSigned(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAssertionSigned(): void;
    /**
     * @stability stable
     */
    get assertionSignedInput(): boolean | cdktf.IResolvable | undefined;
    private _audience?;
    /**
     * @stability stable
     */
    get audience(): string;
    /**
     * @stability stable
     */
    set audience(value: string);
    /**
     * @stability stable
     */
    resetAudience(): void;
    /**
     * @stability stable
     */
    get audienceInput(): string | undefined;
    private _authnContextClassRef?;
    /**
     * @stability stable
     */
    get authnContextClassRef(): string;
    /**
     * @stability stable
     */
    set authnContextClassRef(value: string);
    /**
     * @stability stable
     */
    resetAuthnContextClassRef(): void;
    /**
     * @stability stable
     */
    get authnContextClassRefInput(): string | undefined;
    private _autoSubmitToolbar?;
    /**
     * @stability stable
     */
    get autoSubmitToolbar(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set autoSubmitToolbar(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAutoSubmitToolbar(): void;
    /**
     * @stability stable
     */
    get autoSubmitToolbarInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get certificate(): string;
    private _defaultRelayState?;
    /**
     * @stability stable
     */
    get defaultRelayState(): string;
    /**
     * @stability stable
     */
    set defaultRelayState(value: string);
    /**
     * @stability stable
     */
    resetDefaultRelayState(): void;
    /**
     * @stability stable
     */
    get defaultRelayStateInput(): string | undefined;
    private _destination?;
    /**
     * @stability stable
     */
    get destination(): string;
    /**
     * @stability stable
     */
    set destination(value: string);
    /**
     * @stability stable
     */
    resetDestination(): void;
    /**
     * @stability stable
     */
    get destinationInput(): string | undefined;
    private _digestAlgorithm?;
    /**
     * @stability stable
     */
    get digestAlgorithm(): string;
    /**
     * @stability stable
     */
    set digestAlgorithm(value: string);
    /**
     * @stability stable
     */
    resetDigestAlgorithm(): void;
    /**
     * @stability stable
     */
    get digestAlgorithmInput(): string | undefined;
    private _enduserNote?;
    /**
     * @stability stable
     */
    get enduserNote(): string;
    /**
     * @stability stable
     */
    set enduserNote(value: string);
    /**
     * @stability stable
     */
    resetEnduserNote(): void;
    /**
     * @stability stable
     */
    get enduserNoteInput(): string | undefined;
    /**
     * @stability stable
     */
    get entityKey(): string;
    /**
     * @stability stable
     */
    get entityUrl(): string;
    private _features?;
    /**
     * @stability stable
     */
    get features(): string[];
    /**
     * @stability stable
     */
    set features(value: string[]);
    /**
     * @stability stable
     */
    resetFeatures(): void;
    /**
     * @stability stable
     */
    get featuresInput(): string[] | undefined;
    private _groups?;
    /**
     * @stability stable
     */
    get groups(): string[];
    /**
     * @stability stable
     */
    set groups(value: string[]);
    /**
     * @stability stable
     */
    resetGroups(): void;
    /**
     * @stability stable
     */
    get groupsInput(): string[] | undefined;
    private _hideIos?;
    /**
     * @stability stable
     */
    get hideIos(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set hideIos(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHideIos(): void;
    /**
     * @stability stable
     */
    get hideIosInput(): boolean | cdktf.IResolvable | undefined;
    private _hideWeb?;
    /**
     * @stability stable
     */
    get hideWeb(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set hideWeb(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHideWeb(): void;
    /**
     * @stability stable
     */
    get hideWebInput(): boolean | cdktf.IResolvable | undefined;
    private _honorForceAuthn?;
    /**
     * @stability stable
     */
    get honorForceAuthn(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set honorForceAuthn(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHonorForceAuthn(): void;
    /**
     * @stability stable
     */
    get honorForceAuthnInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get httpPostBinding(): string;
    /**
     * @stability stable
     */
    get httpRedirectBinding(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _idpIssuer?;
    /**
     * @stability stable
     */
    get idpIssuer(): string;
    /**
     * @stability stable
     */
    set idpIssuer(value: string);
    /**
     * @stability stable
     */
    resetIdpIssuer(): void;
    /**
     * @stability stable
     */
    get idpIssuerInput(): string | undefined;
    private _implicitAssignment?;
    /**
     * @stability stable
     */
    get implicitAssignment(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set implicitAssignment(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetImplicitAssignment(): void;
    /**
     * @stability stable
     */
    get implicitAssignmentInput(): boolean | cdktf.IResolvable | undefined;
    private _inlineHookId?;
    /**
     * @stability stable
     */
    get inlineHookId(): string;
    /**
     * @stability stable
     */
    set inlineHookId(value: string);
    /**
     * @stability stable
     */
    resetInlineHookId(): void;
    /**
     * @stability stable
     */
    get inlineHookIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get keyId(): string;
    private _keyName?;
    /**
     * @stability stable
     */
    get keyName(): string;
    /**
     * @stability stable
     */
    set keyName(value: string);
    /**
     * @stability stable
     */
    resetKeyName(): void;
    /**
     * @stability stable
     */
    get keyNameInput(): string | undefined;
    private _keyYearsValid?;
    /**
     * @stability stable
     */
    get keyYearsValid(): number;
    /**
     * @stability stable
     */
    set keyYearsValid(value: number);
    /**
     * @stability stable
     */
    resetKeyYearsValid(): void;
    /**
     * @stability stable
     */
    get keyYearsValidInput(): number | undefined;
    private _label?;
    /**
     * @stability stable
     */
    get label(): string;
    /**
     * @stability stable
     */
    set label(value: string);
    /**
     * @stability stable
     */
    get labelInput(): string | undefined;
    private _logo?;
    /**
     * @stability stable
     */
    get logo(): string;
    /**
     * @stability stable
     */
    set logo(value: string);
    /**
     * @stability stable
     */
    resetLogo(): void;
    /**
     * @stability stable
     */
    get logoInput(): string | undefined;
    /**
     * @stability stable
     */
    get logoUrl(): string;
    /**
     * @stability stable
     */
    get metadata(): string;
    /**
     * @stability stable
     */
    get metadataUrl(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _preconfiguredApp?;
    /**
     * @stability stable
     */
    get preconfiguredApp(): string;
    /**
     * @stability stable
     */
    set preconfiguredApp(value: string);
    /**
     * @stability stable
     */
    resetPreconfiguredApp(): void;
    /**
     * @stability stable
     */
    get preconfiguredAppInput(): string | undefined;
    private _recipient?;
    /**
     * @stability stable
     */
    get recipient(): string;
    /**
     * @stability stable
     */
    set recipient(value: string);
    /**
     * @stability stable
     */
    resetRecipient(): void;
    /**
     * @stability stable
     */
    get recipientInput(): string | undefined;
    private _requestCompressed?;
    /**
     * @stability stable
     */
    get requestCompressed(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set requestCompressed(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRequestCompressed(): void;
    /**
     * @stability stable
     */
    get requestCompressedInput(): boolean | cdktf.IResolvable | undefined;
    private _responseSigned?;
    /**
     * @stability stable
     */
    get responseSigned(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set responseSigned(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetResponseSigned(): void;
    /**
     * @stability stable
     */
    get responseSignedInput(): boolean | cdktf.IResolvable | undefined;
    private _samlVersion?;
    /**
     * @stability stable
     */
    get samlVersion(): string;
    /**
     * @stability stable
     */
    set samlVersion(value: string);
    /**
     * @stability stable
     */
    resetSamlVersion(): void;
    /**
     * @stability stable
     */
    get samlVersionInput(): string | undefined;
    /**
     * @stability stable
     */
    get signOnMode(): string;
    private _signatureAlgorithm?;
    /**
     * @stability stable
     */
    get signatureAlgorithm(): string;
    /**
     * @stability stable
     */
    set signatureAlgorithm(value: string);
    /**
     * @stability stable
     */
    resetSignatureAlgorithm(): void;
    /**
     * @stability stable
     */
    get signatureAlgorithmInput(): string | undefined;
    private _singleLogoutCertificate?;
    /**
     * @stability stable
     */
    get singleLogoutCertificate(): string;
    /**
     * @stability stable
     */
    set singleLogoutCertificate(value: string);
    /**
     * @stability stable
     */
    resetSingleLogoutCertificate(): void;
    /**
     * @stability stable
     */
    get singleLogoutCertificateInput(): string | undefined;
    private _singleLogoutIssuer?;
    /**
     * @stability stable
     */
    get singleLogoutIssuer(): string;
    /**
     * @stability stable
     */
    set singleLogoutIssuer(value: string);
    /**
     * @stability stable
     */
    resetSingleLogoutIssuer(): void;
    /**
     * @stability stable
     */
    get singleLogoutIssuerInput(): string | undefined;
    private _singleLogoutUrl?;
    /**
     * @stability stable
     */
    get singleLogoutUrl(): string;
    /**
     * @stability stable
     */
    set singleLogoutUrl(value: string);
    /**
     * @stability stable
     */
    resetSingleLogoutUrl(): void;
    /**
     * @stability stable
     */
    get singleLogoutUrlInput(): string | undefined;
    private _skipGroups?;
    /**
     * @stability stable
     */
    get skipGroups(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set skipGroups(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSkipGroups(): void;
    /**
     * @stability stable
     */
    get skipGroupsInput(): boolean | cdktf.IResolvable | undefined;
    private _skipUsers?;
    /**
     * @stability stable
     */
    get skipUsers(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set skipUsers(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSkipUsers(): void;
    /**
     * @stability stable
     */
    get skipUsersInput(): boolean | cdktf.IResolvable | undefined;
    private _spIssuer?;
    /**
     * @stability stable
     */
    get spIssuer(): string;
    /**
     * @stability stable
     */
    set spIssuer(value: string);
    /**
     * @stability stable
     */
    resetSpIssuer(): void;
    /**
     * @stability stable
     */
    get spIssuerInput(): string | undefined;
    private _ssoUrl?;
    /**
     * @stability stable
     */
    get ssoUrl(): string;
    /**
     * @stability stable
     */
    set ssoUrl(value: string);
    /**
     * @stability stable
     */
    resetSsoUrl(): void;
    /**
     * @stability stable
     */
    get ssoUrlInput(): string | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    set status(value: string);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    private _subjectNameIdFormat?;
    /**
     * @stability stable
     */
    get subjectNameIdFormat(): string;
    /**
     * @stability stable
     */
    set subjectNameIdFormat(value: string);
    /**
     * @stability stable
     */
    resetSubjectNameIdFormat(): void;
    /**
     * @stability stable
     */
    get subjectNameIdFormatInput(): string | undefined;
    private _subjectNameIdTemplate?;
    /**
     * @stability stable
     */
    get subjectNameIdTemplate(): string;
    /**
     * @stability stable
     */
    set subjectNameIdTemplate(value: string);
    /**
     * @stability stable
     */
    resetSubjectNameIdTemplate(): void;
    /**
     * @stability stable
     */
    get subjectNameIdTemplateInput(): string | undefined;
    private _userNameTemplate?;
    /**
     * @stability stable
     */
    get userNameTemplate(): string;
    /**
     * @stability stable
     */
    set userNameTemplate(value: string);
    /**
     * @stability stable
     */
    resetUserNameTemplate(): void;
    /**
     * @stability stable
     */
    get userNameTemplateInput(): string | undefined;
    private _userNameTemplatePushStatus?;
    /**
     * @stability stable
     */
    get userNameTemplatePushStatus(): string;
    /**
     * @stability stable
     */
    set userNameTemplatePushStatus(value: string);
    /**
     * @stability stable
     */
    resetUserNameTemplatePushStatus(): void;
    /**
     * @stability stable
     */
    get userNameTemplatePushStatusInput(): string | undefined;
    private _userNameTemplateSuffix?;
    /**
     * @stability stable
     */
    get userNameTemplateSuffix(): string;
    /**
     * @stability stable
     */
    set userNameTemplateSuffix(value: string);
    /**
     * @stability stable
     */
    resetUserNameTemplateSuffix(): void;
    /**
     * @stability stable
     */
    get userNameTemplateSuffixInput(): string | undefined;
    private _userNameTemplateType?;
    /**
     * @stability stable
     */
    get userNameTemplateType(): string;
    /**
     * @stability stable
     */
    set userNameTemplateType(value: string);
    /**
     * @stability stable
     */
    resetUserNameTemplateType(): void;
    /**
     * @stability stable
     */
    get userNameTemplateTypeInput(): string | undefined;
    private _attributeStatements?;
    /**
     * @stability stable
     */
    get attributeStatements(): AppSamlAttributeStatements[];
    /**
     * @stability stable
     */
    set attributeStatements(value: AppSamlAttributeStatements[]);
    /**
     * @stability stable
     */
    resetAttributeStatements(): void;
    /**
     * @stability stable
     */
    get attributeStatementsInput(): AppSamlAttributeStatements[] | undefined;
    private _users?;
    /**
     * @stability stable
     */
    get users(): AppSamlUsers[];
    /**
     * @stability stable
     */
    set users(value: AppSamlUsers[]);
    /**
     * @stability stable
     */
    resetUsers(): void;
    /**
     * @stability stable
     */
    get usersInput(): AppSamlUsers[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
