import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AppSharedCredentialsConfig extends cdktf.TerraformMetaArguments {
    /**
     * Custom error page URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials.html#accessibility_error_redirect_url AppSharedCredentials#accessibility_error_redirect_url}
     *
     * @stability stable
     */
    readonly accessibilityErrorRedirectUrl?: string;
    /**
     * Custom login page URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials.html#accessibility_login_redirect_url AppSharedCredentials#accessibility_login_redirect_url}
     *
     * @stability stable
     */
    readonly accessibilityLoginRedirectUrl?: string;
    /**
     * Enable self service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials.html#accessibility_self_service AppSharedCredentials#accessibility_self_service}
     *
     * @stability stable
     */
    readonly accessibilitySelfService?: boolean | cdktf.IResolvable;
    /**
     * Application notes for admins.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials.html#admin_note AppSharedCredentials#admin_note}
     *
     * @stability stable
     */
    readonly adminNote?: string;
    /**
     * Displays specific appLinks for the app.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials.html#app_links_json AppSharedCredentials#app_links_json}
     *
     * @stability stable
     */
    readonly appLinksJson?: string;
    /**
     * Display auto submit toolbar.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials.html#auto_submit_toolbar AppSharedCredentials#auto_submit_toolbar}
     *
     * @stability stable
     */
    readonly autoSubmitToolbar?: boolean | cdktf.IResolvable;
    /**
     * Login button field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials.html#button_field AppSharedCredentials#button_field}
     *
     * @stability stable
     */
    readonly buttonField?: string;
    /**
     * CSS selector for the checkbox.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials.html#checkbox AppSharedCredentials#checkbox}
     *
     * @stability stable
     */
    readonly checkbox?: string;
    /**
     * Application notes for end users.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials.html#enduser_note AppSharedCredentials#enduser_note}
     *
     * @stability stable
     */
    readonly enduserNote?: string;
    /**
     * Groups associated with the application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials.html#groups AppSharedCredentials#groups}
     *
     * @stability stable
     */
    readonly groups?: string[];
    /**
     * Do not display application icon on mobile app.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials.html#hide_ios AppSharedCredentials#hide_ios}
     *
     * @stability stable
     */
    readonly hideIos?: boolean | cdktf.IResolvable;
    /**
     * Do not display application icon to users.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials.html#hide_web AppSharedCredentials#hide_web}
     *
     * @stability stable
     */
    readonly hideWeb?: boolean | cdktf.IResolvable;
    /**
     * Pretty name of app.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials.html#label AppSharedCredentials#label}
     *
     * @stability stable
     */
    readonly label: string;
    /**
     * Local path to logo of the application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials.html#logo AppSharedCredentials#logo}
     *
     * @stability stable
     */
    readonly logo?: string;
    /**
     * Login password field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials.html#password_field AppSharedCredentials#password_field}
     *
     * @stability stable
     */
    readonly passwordField?: string;
    /**
     * Preconfigured app name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials.html#preconfigured_app AppSharedCredentials#preconfigured_app}
     *
     * @stability stable
     */
    readonly preconfiguredApp?: string;
    /**
     * Secondary URL of the sign-in page for this app.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials.html#redirect_url AppSharedCredentials#redirect_url}
     *
     * @stability stable
     */
    readonly redirectUrl?: string;
    /**
     * Shared password, required for certain schemes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials.html#shared_password AppSharedCredentials#shared_password}
     *
     * @stability stable
     */
    readonly sharedPassword?: string;
    /**
     * Shared username, required for certain schemes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials.html#shared_username AppSharedCredentials#shared_username}
     *
     * @stability stable
     */
    readonly sharedUsername?: string;
    /**
     * Ignore groups sync. This is a temporary solution until 'groups' field is supported in all the app-like resources.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials.html#skip_groups AppSharedCredentials#skip_groups}
     *
     * @stability stable
     */
    readonly skipGroups?: boolean | cdktf.IResolvable;
    /**
     * Ignore users sync. This is a temporary solution until 'users' field is supported in all the app-like resources.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials.html#skip_users AppSharedCredentials#skip_users}
     *
     * @stability stable
     */
    readonly skipUsers?: boolean | cdktf.IResolvable;
    /**
     * Status of application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials.html#status AppSharedCredentials#status}
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * Login URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials.html#url AppSharedCredentials#url}
     *
     * @stability stable
     */
    readonly url?: string;
    /**
     * A regex that further restricts URL to the specified regex.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials.html#url_regex AppSharedCredentials#url_regex}
     *
     * @stability stable
     */
    readonly urlRegex?: string;
    /**
     * Username template.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials.html#user_name_template AppSharedCredentials#user_name_template}
     *
     * @stability stable
     */
    readonly userNameTemplate?: string;
    /**
     * Push username on update.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials.html#user_name_template_push_status AppSharedCredentials#user_name_template_push_status}
     *
     * @stability stable
     */
    readonly userNameTemplatePushStatus?: string;
    /**
     * Username template suffix.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials.html#user_name_template_suffix AppSharedCredentials#user_name_template_suffix}
     *
     * @stability stable
     */
    readonly userNameTemplateSuffix?: string;
    /**
     * Username template type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials.html#user_name_template_type AppSharedCredentials#user_name_template_type}
     *
     * @stability stable
     */
    readonly userNameTemplateType?: string;
    /**
     * Login username field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials.html#username_field AppSharedCredentials#username_field}
     *
     * @stability stable
     */
    readonly usernameField?: string;
    /**
     * users block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials.html#users AppSharedCredentials#users}
     *
     * @stability stable
     */
    readonly users?: AppSharedCredentialsUsers[];
}
/**
 * @stability stable
 */
export interface AppSharedCredentialsUsers {
    /**
     * User ID.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials.html#id AppSharedCredentials#id}
     *
     * @stability stable
     */
    readonly id?: string;
    /**
     * Password for user application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials.html#password AppSharedCredentials#password}
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * Username for user.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials.html#username AppSharedCredentials#username}
     *
     * @stability stable
     */
    readonly username?: string;
}
export declare function appSharedCredentialsUsersToTerraform(struct?: AppSharedCredentialsUsers): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials.html okta_app_shared_credentials}.
 *
 * @stability stable
 */
export declare class AppSharedCredentials extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials.html okta_app_shared_credentials} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AppSharedCredentialsConfig);
    private _accessibilityErrorRedirectUrl?;
    /**
     * @stability stable
     */
    get accessibilityErrorRedirectUrl(): string;
    /**
     * @stability stable
     */
    set accessibilityErrorRedirectUrl(value: string);
    /**
     * @stability stable
     */
    resetAccessibilityErrorRedirectUrl(): void;
    /**
     * @stability stable
     */
    get accessibilityErrorRedirectUrlInput(): string | undefined;
    private _accessibilityLoginRedirectUrl?;
    /**
     * @stability stable
     */
    get accessibilityLoginRedirectUrl(): string;
    /**
     * @stability stable
     */
    set accessibilityLoginRedirectUrl(value: string);
    /**
     * @stability stable
     */
    resetAccessibilityLoginRedirectUrl(): void;
    /**
     * @stability stable
     */
    get accessibilityLoginRedirectUrlInput(): string | undefined;
    private _accessibilitySelfService?;
    /**
     * @stability stable
     */
    get accessibilitySelfService(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set accessibilitySelfService(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAccessibilitySelfService(): void;
    /**
     * @stability stable
     */
    get accessibilitySelfServiceInput(): boolean | cdktf.IResolvable | undefined;
    private _adminNote?;
    /**
     * @stability stable
     */
    get adminNote(): string;
    /**
     * @stability stable
     */
    set adminNote(value: string);
    /**
     * @stability stable
     */
    resetAdminNote(): void;
    /**
     * @stability stable
     */
    get adminNoteInput(): string | undefined;
    private _appLinksJson?;
    /**
     * @stability stable
     */
    get appLinksJson(): string;
    /**
     * @stability stable
     */
    set appLinksJson(value: string);
    /**
     * @stability stable
     */
    resetAppLinksJson(): void;
    /**
     * @stability stable
     */
    get appLinksJsonInput(): string | undefined;
    private _autoSubmitToolbar?;
    /**
     * @stability stable
     */
    get autoSubmitToolbar(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set autoSubmitToolbar(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAutoSubmitToolbar(): void;
    /**
     * @stability stable
     */
    get autoSubmitToolbarInput(): boolean | cdktf.IResolvable | undefined;
    private _buttonField?;
    /**
     * @stability stable
     */
    get buttonField(): string;
    /**
     * @stability stable
     */
    set buttonField(value: string);
    /**
     * @stability stable
     */
    resetButtonField(): void;
    /**
     * @stability stable
     */
    get buttonFieldInput(): string | undefined;
    private _checkbox?;
    /**
     * @stability stable
     */
    get checkbox(): string;
    /**
     * @stability stable
     */
    set checkbox(value: string);
    /**
     * @stability stable
     */
    resetCheckbox(): void;
    /**
     * @stability stable
     */
    get checkboxInput(): string | undefined;
    private _enduserNote?;
    /**
     * @stability stable
     */
    get enduserNote(): string;
    /**
     * @stability stable
     */
    set enduserNote(value: string);
    /**
     * @stability stable
     */
    resetEnduserNote(): void;
    /**
     * @stability stable
     */
    get enduserNoteInput(): string | undefined;
    private _groups?;
    /**
     * @stability stable
     */
    get groups(): string[];
    /**
     * @stability stable
     */
    set groups(value: string[]);
    /**
     * @stability stable
     */
    resetGroups(): void;
    /**
     * @stability stable
     */
    get groupsInput(): string[] | undefined;
    private _hideIos?;
    /**
     * @stability stable
     */
    get hideIos(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set hideIos(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHideIos(): void;
    /**
     * @stability stable
     */
    get hideIosInput(): boolean | cdktf.IResolvable | undefined;
    private _hideWeb?;
    /**
     * @stability stable
     */
    get hideWeb(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set hideWeb(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHideWeb(): void;
    /**
     * @stability stable
     */
    get hideWebInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _label?;
    /**
     * @stability stable
     */
    get label(): string;
    /**
     * @stability stable
     */
    set label(value: string);
    /**
     * @stability stable
     */
    get labelInput(): string | undefined;
    private _logo?;
    /**
     * @stability stable
     */
    get logo(): string;
    /**
     * @stability stable
     */
    set logo(value: string);
    /**
     * @stability stable
     */
    resetLogo(): void;
    /**
     * @stability stable
     */
    get logoInput(): string | undefined;
    /**
     * @stability stable
     */
    get logoUrl(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _passwordField?;
    /**
     * @stability stable
     */
    get passwordField(): string;
    /**
     * @stability stable
     */
    set passwordField(value: string);
    /**
     * @stability stable
     */
    resetPasswordField(): void;
    /**
     * @stability stable
     */
    get passwordFieldInput(): string | undefined;
    private _preconfiguredApp?;
    /**
     * @stability stable
     */
    get preconfiguredApp(): string;
    /**
     * @stability stable
     */
    set preconfiguredApp(value: string);
    /**
     * @stability stable
     */
    resetPreconfiguredApp(): void;
    /**
     * @stability stable
     */
    get preconfiguredAppInput(): string | undefined;
    private _redirectUrl?;
    /**
     * @stability stable
     */
    get redirectUrl(): string;
    /**
     * @stability stable
     */
    set redirectUrl(value: string);
    /**
     * @stability stable
     */
    resetRedirectUrl(): void;
    /**
     * @stability stable
     */
    get redirectUrlInput(): string | undefined;
    private _sharedPassword?;
    /**
     * @stability stable
     */
    get sharedPassword(): string;
    /**
     * @stability stable
     */
    set sharedPassword(value: string);
    /**
     * @stability stable
     */
    resetSharedPassword(): void;
    /**
     * @stability stable
     */
    get sharedPasswordInput(): string | undefined;
    private _sharedUsername?;
    /**
     * @stability stable
     */
    get sharedUsername(): string;
    /**
     * @stability stable
     */
    set sharedUsername(value: string);
    /**
     * @stability stable
     */
    resetSharedUsername(): void;
    /**
     * @stability stable
     */
    get sharedUsernameInput(): string | undefined;
    /**
     * @stability stable
     */
    get signOnMode(): string;
    private _skipGroups?;
    /**
     * @stability stable
     */
    get skipGroups(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set skipGroups(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSkipGroups(): void;
    /**
     * @stability stable
     */
    get skipGroupsInput(): boolean | cdktf.IResolvable | undefined;
    private _skipUsers?;
    /**
     * @stability stable
     */
    get skipUsers(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set skipUsers(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSkipUsers(): void;
    /**
     * @stability stable
     */
    get skipUsersInput(): boolean | cdktf.IResolvable | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    set status(value: string);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    private _url?;
    /**
     * @stability stable
     */
    get url(): string;
    /**
     * @stability stable
     */
    set url(value: string);
    /**
     * @stability stable
     */
    resetUrl(): void;
    /**
     * @stability stable
     */
    get urlInput(): string | undefined;
    private _urlRegex?;
    /**
     * @stability stable
     */
    get urlRegex(): string;
    /**
     * @stability stable
     */
    set urlRegex(value: string);
    /**
     * @stability stable
     */
    resetUrlRegex(): void;
    /**
     * @stability stable
     */
    get urlRegexInput(): string | undefined;
    private _userNameTemplate?;
    /**
     * @stability stable
     */
    get userNameTemplate(): string;
    /**
     * @stability stable
     */
    set userNameTemplate(value: string);
    /**
     * @stability stable
     */
    resetUserNameTemplate(): void;
    /**
     * @stability stable
     */
    get userNameTemplateInput(): string | undefined;
    private _userNameTemplatePushStatus?;
    /**
     * @stability stable
     */
    get userNameTemplatePushStatus(): string;
    /**
     * @stability stable
     */
    set userNameTemplatePushStatus(value: string);
    /**
     * @stability stable
     */
    resetUserNameTemplatePushStatus(): void;
    /**
     * @stability stable
     */
    get userNameTemplatePushStatusInput(): string | undefined;
    private _userNameTemplateSuffix?;
    /**
     * @stability stable
     */
    get userNameTemplateSuffix(): string;
    /**
     * @stability stable
     */
    set userNameTemplateSuffix(value: string);
    /**
     * @stability stable
     */
    resetUserNameTemplateSuffix(): void;
    /**
     * @stability stable
     */
    get userNameTemplateSuffixInput(): string | undefined;
    private _userNameTemplateType?;
    /**
     * @stability stable
     */
    get userNameTemplateType(): string;
    /**
     * @stability stable
     */
    set userNameTemplateType(value: string);
    /**
     * @stability stable
     */
    resetUserNameTemplateType(): void;
    /**
     * @stability stable
     */
    get userNameTemplateTypeInput(): string | undefined;
    private _usernameField?;
    /**
     * @stability stable
     */
    get usernameField(): string;
    /**
     * @stability stable
     */
    set usernameField(value: string);
    /**
     * @stability stable
     */
    resetUsernameField(): void;
    /**
     * @stability stable
     */
    get usernameFieldInput(): string | undefined;
    private _users?;
    /**
     * @stability stable
     */
    get users(): AppSharedCredentialsUsers[];
    /**
     * @stability stable
     */
    set users(value: AppSharedCredentialsUsers[]);
    /**
     * @stability stable
     */
    resetUsers(): void;
    /**
     * @stability stable
     */
    get usersInput(): AppSharedCredentialsUsers[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
