import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AppSignonPolicyRuleConfig extends cdktf.TerraformMetaArguments {
    /**
     * Allow or deny access based on the rule conditions: ALLOW or DENY.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule.html#access AppSignonPolicyRule#access}
     *
     * @stability stable
     */
    readonly access?: string;
    /**
     * An array that contains nested Authenticator Constraint objects that are organized by the Authenticator class.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule.html#constraints AppSignonPolicyRule#constraints}
     *
     * @stability stable
     */
    readonly constraints?: string[];
    /**
     * This is an optional advanced setting.
     *
     * If the expression is formatted incorrectly or conflicts with conditions set above, the rule may not match any users.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule.html#custom_expression AppSignonPolicyRule#custom_expression}
     *
     * @stability stable
     */
    readonly customExpression?: string;
    /**
     * If the device is managed.
     *
     * A device is managed if it's managed by a device management system. When managed is passed, registered must also be included and must be set to true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule.html#device_is_managed AppSignonPolicyRule#device_is_managed}
     *
     * @stability stable
     */
    readonly deviceIsManaged?: boolean | cdktf.IResolvable;
    /**
     * If the device is registered.
     *
     * A device is registered if the User enrolls with Okta Verify that is installed on the device.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule.html#device_is_registered AppSignonPolicyRule#device_is_registered}
     *
     * @stability stable
     */
    readonly deviceIsRegistered?: boolean | cdktf.IResolvable;
    /**
     * The number of factors required to satisfy this assurance level.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule.html#factor_mode AppSignonPolicyRule#factor_mode}
     *
     * @stability stable
     */
    readonly factorMode?: string;
    /**
     * List of group IDs to exclude.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule.html#groups_excluded AppSignonPolicyRule#groups_excluded}
     *
     * @stability stable
     */
    readonly groupsExcluded?: string[];
    /**
     * List of group IDs to include.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule.html#groups_included AppSignonPolicyRule#groups_included}
     *
     * @stability stable
     */
    readonly groupsIncluded?: string[];
    /**
     * Policy Rule Name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule.html#name AppSignonPolicyRule#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Network selection mode: ANYWHERE, ZONE, ON_NETWORK, or OFF_NETWORK.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule.html#network_connection AppSignonPolicyRule#network_connection}
     *
     * @stability stable
     */
    readonly networkConnection?: string;
    /**
     * The zones to exclude.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule.html#network_excludes AppSignonPolicyRule#network_excludes}
     *
     * @stability stable
     */
    readonly networkExcludes?: string[];
    /**
     * The zones to include.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule.html#network_includes AppSignonPolicyRule#network_includes}
     *
     * @stability stable
     */
    readonly networkIncludes?: string[];
    /**
     * ID of the policy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule.html#policy_id AppSignonPolicyRule#policy_id}
     *
     * @stability stable
     */
    readonly policyId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule.html#priority AppSignonPolicyRule#priority}.
     *
     * @stability stable
     */
    readonly priority?: number;
    /**
     * The duration after which the end user must re-authenticate, regardless of user activity.
     *
     * Use the ISO 8601 Period format for recurring time intervals. PT0S - Every sign-in attempt, PT43800H - Once per session
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule.html#re_authentication_frequency AppSignonPolicyRule#re_authentication_frequency}
     *
     * @stability stable
     */
    readonly reAuthenticationFrequency?: string;
    /**
     * Status of the rule.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule.html#status AppSignonPolicyRule#status}
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * The Verification Method type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule.html#type AppSignonPolicyRule#type}
     *
     * @stability stable
     */
    readonly type?: string;
    /**
     * Set of User Type IDs to exclude.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule.html#user_types_excluded AppSignonPolicyRule#user_types_excluded}
     *
     * @stability stable
     */
    readonly userTypesExcluded?: string[];
    /**
     * Set of User Type IDs to include.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule.html#user_types_included AppSignonPolicyRule#user_types_included}
     *
     * @stability stable
     */
    readonly userTypesIncluded?: string[];
    /**
     * Set of User IDs to exclude.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule.html#users_excluded AppSignonPolicyRule#users_excluded}
     *
     * @stability stable
     */
    readonly usersExcluded?: string[];
    /**
     * Set of User IDs to include.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule.html#users_included AppSignonPolicyRule#users_included}
     *
     * @stability stable
     */
    readonly usersIncluded?: string[];
    /**
     * platform_include block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule.html#platform_include AppSignonPolicyRule#platform_include}
     *
     * @stability stable
     */
    readonly platformInclude?: AppSignonPolicyRulePlatformInclude[];
}
/**
 * @stability stable
 */
export interface AppSignonPolicyRulePlatformInclude {
    /**
     * Only available with OTHER OS type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule.html#os_expression AppSignonPolicyRule#os_expression}
     *
     * @stability stable
     */
    readonly osExpression?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule.html#os_type AppSignonPolicyRule#os_type}.
     *
     * @stability stable
     */
    readonly osType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule.html#type AppSignonPolicyRule#type}.
     *
     * @stability stable
     */
    readonly type?: string;
}
export declare function appSignonPolicyRulePlatformIncludeToTerraform(struct?: AppSignonPolicyRulePlatformInclude): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule.html okta_app_signon_policy_rule}.
 *
 * @stability stable
 */
export declare class AppSignonPolicyRule extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule.html okta_app_signon_policy_rule} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AppSignonPolicyRuleConfig);
    private _access?;
    /**
     * @stability stable
     */
    get access(): string;
    /**
     * @stability stable
     */
    set access(value: string);
    /**
     * @stability stable
     */
    resetAccess(): void;
    /**
     * @stability stable
     */
    get accessInput(): string | undefined;
    private _constraints?;
    /**
     * @stability stable
     */
    get constraints(): string[];
    /**
     * @stability stable
     */
    set constraints(value: string[]);
    /**
     * @stability stable
     */
    resetConstraints(): void;
    /**
     * @stability stable
     */
    get constraintsInput(): string[] | undefined;
    private _customExpression?;
    /**
     * @stability stable
     */
    get customExpression(): string;
    /**
     * @stability stable
     */
    set customExpression(value: string);
    /**
     * @stability stable
     */
    resetCustomExpression(): void;
    /**
     * @stability stable
     */
    get customExpressionInput(): string | undefined;
    private _deviceIsManaged?;
    /**
     * @stability stable
     */
    get deviceIsManaged(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set deviceIsManaged(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDeviceIsManaged(): void;
    /**
     * @stability stable
     */
    get deviceIsManagedInput(): boolean | cdktf.IResolvable | undefined;
    private _deviceIsRegistered?;
    /**
     * @stability stable
     */
    get deviceIsRegistered(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set deviceIsRegistered(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDeviceIsRegistered(): void;
    /**
     * @stability stable
     */
    get deviceIsRegisteredInput(): boolean | cdktf.IResolvable | undefined;
    private _factorMode?;
    /**
     * @stability stable
     */
    get factorMode(): string;
    /**
     * @stability stable
     */
    set factorMode(value: string);
    /**
     * @stability stable
     */
    resetFactorMode(): void;
    /**
     * @stability stable
     */
    get factorModeInput(): string | undefined;
    private _groupsExcluded?;
    /**
     * @stability stable
     */
    get groupsExcluded(): string[];
    /**
     * @stability stable
     */
    set groupsExcluded(value: string[]);
    /**
     * @stability stable
     */
    resetGroupsExcluded(): void;
    /**
     * @stability stable
     */
    get groupsExcludedInput(): string[] | undefined;
    private _groupsIncluded?;
    /**
     * @stability stable
     */
    get groupsIncluded(): string[];
    /**
     * @stability stable
     */
    set groupsIncluded(value: string[]);
    /**
     * @stability stable
     */
    resetGroupsIncluded(): void;
    /**
     * @stability stable
     */
    get groupsIncludedInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _networkConnection?;
    /**
     * @stability stable
     */
    get networkConnection(): string;
    /**
     * @stability stable
     */
    set networkConnection(value: string);
    /**
     * @stability stable
     */
    resetNetworkConnection(): void;
    /**
     * @stability stable
     */
    get networkConnectionInput(): string | undefined;
    private _networkExcludes?;
    /**
     * @stability stable
     */
    get networkExcludes(): string[];
    /**
     * @stability stable
     */
    set networkExcludes(value: string[]);
    /**
     * @stability stable
     */
    resetNetworkExcludes(): void;
    /**
     * @stability stable
     */
    get networkExcludesInput(): string[] | undefined;
    private _networkIncludes?;
    /**
     * @stability stable
     */
    get networkIncludes(): string[];
    /**
     * @stability stable
     */
    set networkIncludes(value: string[]);
    /**
     * @stability stable
     */
    resetNetworkIncludes(): void;
    /**
     * @stability stable
     */
    get networkIncludesInput(): string[] | undefined;
    private _policyId?;
    /**
     * @stability stable
     */
    get policyId(): string;
    /**
     * @stability stable
     */
    set policyId(value: string);
    /**
     * @stability stable
     */
    get policyIdInput(): string | undefined;
    private _priority?;
    /**
     * @stability stable
     */
    get priority(): number;
    /**
     * @stability stable
     */
    set priority(value: number);
    /**
     * @stability stable
     */
    resetPriority(): void;
    /**
     * @stability stable
     */
    get priorityInput(): number | undefined;
    private _reAuthenticationFrequency?;
    /**
     * @stability stable
     */
    get reAuthenticationFrequency(): string;
    /**
     * @stability stable
     */
    set reAuthenticationFrequency(value: string);
    /**
     * @stability stable
     */
    resetReAuthenticationFrequency(): void;
    /**
     * @stability stable
     */
    get reAuthenticationFrequencyInput(): string | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    set status(value: string);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    resetType(): void;
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _userTypesExcluded?;
    /**
     * @stability stable
     */
    get userTypesExcluded(): string[];
    /**
     * @stability stable
     */
    set userTypesExcluded(value: string[]);
    /**
     * @stability stable
     */
    resetUserTypesExcluded(): void;
    /**
     * @stability stable
     */
    get userTypesExcludedInput(): string[] | undefined;
    private _userTypesIncluded?;
    /**
     * @stability stable
     */
    get userTypesIncluded(): string[];
    /**
     * @stability stable
     */
    set userTypesIncluded(value: string[]);
    /**
     * @stability stable
     */
    resetUserTypesIncluded(): void;
    /**
     * @stability stable
     */
    get userTypesIncludedInput(): string[] | undefined;
    private _usersExcluded?;
    /**
     * @stability stable
     */
    get usersExcluded(): string[];
    /**
     * @stability stable
     */
    set usersExcluded(value: string[]);
    /**
     * @stability stable
     */
    resetUsersExcluded(): void;
    /**
     * @stability stable
     */
    get usersExcludedInput(): string[] | undefined;
    private _usersIncluded?;
    /**
     * @stability stable
     */
    get usersIncluded(): string[];
    /**
     * @stability stable
     */
    set usersIncluded(value: string[]);
    /**
     * @stability stable
     */
    resetUsersIncluded(): void;
    /**
     * @stability stable
     */
    get usersIncludedInput(): string[] | undefined;
    private _platformInclude?;
    /**
     * @stability stable
     */
    get platformInclude(): AppSignonPolicyRulePlatformInclude[];
    /**
     * @stability stable
     */
    set platformInclude(value: AppSignonPolicyRulePlatformInclude[]);
    /**
     * @stability stable
     */
    resetPlatformInclude(): void;
    /**
     * @stability stable
     */
    get platformIncludeInput(): AppSignonPolicyRulePlatformInclude[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
