import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AppUserSchemaPropertyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property.html#app_id AppUserSchemaProperty#app_id}.
     *
     * @stability stable
     */
    readonly appId: string;
    /**
     * Custom Subschema enumerated value of a property of type array.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property.html#array_enum AppUserSchemaProperty#array_enum}
     *
     * @stability stable
     */
    readonly arrayEnum?: string[];
    /**
     * Subschema array type: string, number, integer, reference. Type field must be an array.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property.html#array_type AppUserSchemaProperty#array_type}
     *
     * @stability stable
     */
    readonly arrayType?: string;
    /**
     * Custom Subschema description.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property.html#description AppUserSchemaProperty#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Custom Subschema enumerated value of the property. see: developer.okta.com/docs/api/resources/schemas#user-profile-schema-property-object.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property.html#enum AppUserSchemaProperty#enum}
     *
     * @stability stable
     */
    readonly enum?: string[];
    /**
     * Subschema external name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property.html#external_name AppUserSchemaProperty#external_name}
     *
     * @stability stable
     */
    readonly externalName?: string;
    /**
     * Subschema external namespace.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property.html#external_namespace AppUserSchemaProperty#external_namespace}
     *
     * @stability stable
     */
    readonly externalNamespace?: string;
    /**
     * Subschema unique string identifier.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property.html#index AppUserSchemaProperty#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * SubSchema profile manager, if not set it will inherit its setting.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property.html#master AppUserSchemaProperty#master}
     *
     * @stability stable
     */
    readonly master?: string;
    /**
     * Subschema of type string maximum length.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property.html#max_length AppUserSchemaProperty#max_length}
     *
     * @stability stable
     */
    readonly maxLength?: number;
    /**
     * Subschema of type string minimum length.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property.html#min_length AppUserSchemaProperty#min_length}
     *
     * @stability stable
     */
    readonly minLength?: number;
    /**
     * SubSchema permissions: HIDE, READ_ONLY, or READ_WRITE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property.html#permissions AppUserSchemaProperty#permissions}
     *
     * @stability stable
     */
    readonly permissions?: string;
    /**
     * Whether the subschema is required.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property.html#required AppUserSchemaProperty#required}
     *
     * @stability stable
     */
    readonly required?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property.html#scope AppUserSchemaProperty#scope}.
     *
     * @stability stable
     */
    readonly scope?: string;
    /**
     * Subschema title (display name).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property.html#title AppUserSchemaProperty#title}
     *
     * @stability stable
     */
    readonly title: string;
    /**
     * Subschema type: string, boolean, number, integer, array, or object.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property.html#type AppUserSchemaProperty#type}
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Allows to assign attribute's group priority.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property.html#union AppUserSchemaProperty#union}
     *
     * @stability stable
     */
    readonly union?: boolean | cdktf.IResolvable;
    /**
     * Subschema unique restriction.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property.html#unique AppUserSchemaProperty#unique}
     *
     * @stability stable
     */
    readonly unique?: string;
    /**
     * Custom subschema user type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property.html#user_type AppUserSchemaProperty#user_type}
     *
     * @stability stable
     */
    readonly userType?: string;
    /**
     * array_one_of block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property.html#array_one_of AppUserSchemaProperty#array_one_of}
     *
     * @stability stable
     */
    readonly arrayOneOf?: AppUserSchemaPropertyArrayOneOf[];
    /**
     * one_of block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property.html#one_of AppUserSchemaProperty#one_of}
     *
     * @stability stable
     */
    readonly oneOf?: AppUserSchemaPropertyOneOf[];
}
/**
 * @stability stable
 */
export interface AppUserSchemaPropertyArrayOneOf {
    /**
     * Enum value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property.html#const AppUserSchemaProperty#const}
     *
     * @stability stable
     */
    readonly const: string;
    /**
     * Enum title.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property.html#title AppUserSchemaProperty#title}
     *
     * @stability stable
     */
    readonly title: string;
}
export declare function appUserSchemaPropertyArrayOneOfToTerraform(struct?: AppUserSchemaPropertyArrayOneOf): any;
/**
 * @stability stable
 */
export interface AppUserSchemaPropertyOneOf {
    /**
     * Enum value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property.html#const AppUserSchemaProperty#const}
     *
     * @stability stable
     */
    readonly const: string;
    /**
     * Enum title.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property.html#title AppUserSchemaProperty#title}
     *
     * @stability stable
     */
    readonly title: string;
}
export declare function appUserSchemaPropertyOneOfToTerraform(struct?: AppUserSchemaPropertyOneOf): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property.html okta_app_user_schema_property}.
 *
 * @stability stable
 */
export declare class AppUserSchemaProperty extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property.html okta_app_user_schema_property} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AppUserSchemaPropertyConfig);
    private _appId?;
    /**
     * @stability stable
     */
    get appId(): string;
    /**
     * @stability stable
     */
    set appId(value: string);
    /**
     * @stability stable
     */
    get appIdInput(): string | undefined;
    private _arrayEnum?;
    /**
     * @stability stable
     */
    get arrayEnum(): string[];
    /**
     * @stability stable
     */
    set arrayEnum(value: string[]);
    /**
     * @stability stable
     */
    resetArrayEnum(): void;
    /**
     * @stability stable
     */
    get arrayEnumInput(): string[] | undefined;
    private _arrayType?;
    /**
     * @stability stable
     */
    get arrayType(): string;
    /**
     * @stability stable
     */
    set arrayType(value: string);
    /**
     * @stability stable
     */
    resetArrayType(): void;
    /**
     * @stability stable
     */
    get arrayTypeInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _enum?;
    /**
     * @stability stable
     */
    get enum(): string[];
    /**
     * @stability stable
     */
    set enum(value: string[]);
    /**
     * @stability stable
     */
    resetEnum(): void;
    /**
     * @stability stable
     */
    get enumInput(): string[] | undefined;
    private _externalName?;
    /**
     * @stability stable
     */
    get externalName(): string;
    /**
     * @stability stable
     */
    set externalName(value: string);
    /**
     * @stability stable
     */
    resetExternalName(): void;
    /**
     * @stability stable
     */
    get externalNameInput(): string | undefined;
    private _externalNamespace?;
    /**
     * @stability stable
     */
    get externalNamespace(): string;
    /**
     * @stability stable
     */
    set externalNamespace(value: string);
    /**
     * @stability stable
     */
    resetExternalNamespace(): void;
    /**
     * @stability stable
     */
    get externalNamespaceInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _master?;
    /**
     * @stability stable
     */
    get master(): string;
    /**
     * @stability stable
     */
    set master(value: string);
    /**
     * @stability stable
     */
    resetMaster(): void;
    /**
     * @stability stable
     */
    get masterInput(): string | undefined;
    private _maxLength?;
    /**
     * @stability stable
     */
    get maxLength(): number;
    /**
     * @stability stable
     */
    set maxLength(value: number);
    /**
     * @stability stable
     */
    resetMaxLength(): void;
    /**
     * @stability stable
     */
    get maxLengthInput(): number | undefined;
    private _minLength?;
    /**
     * @stability stable
     */
    get minLength(): number;
    /**
     * @stability stable
     */
    set minLength(value: number);
    /**
     * @stability stable
     */
    resetMinLength(): void;
    /**
     * @stability stable
     */
    get minLengthInput(): number | undefined;
    private _permissions?;
    /**
     * @stability stable
     */
    get permissions(): string;
    /**
     * @stability stable
     */
    set permissions(value: string);
    /**
     * @stability stable
     */
    resetPermissions(): void;
    /**
     * @stability stable
     */
    get permissionsInput(): string | undefined;
    private _required?;
    /**
     * @stability stable
     */
    get required(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set required(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRequired(): void;
    /**
     * @stability stable
     */
    get requiredInput(): boolean | cdktf.IResolvable | undefined;
    private _scope?;
    /**
     * @stability stable
     */
    get scope(): string;
    /**
     * @stability stable
     */
    set scope(value: string);
    /**
     * @stability stable
     */
    resetScope(): void;
    /**
     * @stability stable
     */
    get scopeInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _union?;
    /**
     * @stability stable
     */
    get union(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set union(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetUnion(): void;
    /**
     * @stability stable
     */
    get unionInput(): boolean | cdktf.IResolvable | undefined;
    private _unique?;
    /**
     * @stability stable
     */
    get unique(): string;
    /**
     * @stability stable
     */
    set unique(value: string);
    /**
     * @stability stable
     */
    resetUnique(): void;
    /**
     * @stability stable
     */
    get uniqueInput(): string | undefined;
    private _userType?;
    /**
     * @stability stable
     */
    get userType(): string;
    /**
     * @stability stable
     */
    set userType(value: string);
    /**
     * @stability stable
     */
    resetUserType(): void;
    /**
     * @stability stable
     */
    get userTypeInput(): string | undefined;
    private _arrayOneOf?;
    /**
     * @stability stable
     */
    get arrayOneOf(): AppUserSchemaPropertyArrayOneOf[];
    /**
     * @stability stable
     */
    set arrayOneOf(value: AppUserSchemaPropertyArrayOneOf[]);
    /**
     * @stability stable
     */
    resetArrayOneOf(): void;
    /**
     * @stability stable
     */
    get arrayOneOfInput(): AppUserSchemaPropertyArrayOneOf[] | undefined;
    private _oneOf?;
    /**
     * @stability stable
     */
    get oneOf(): AppUserSchemaPropertyOneOf[];
    /**
     * @stability stable
     */
    set oneOf(value: AppUserSchemaPropertyOneOf[]);
    /**
     * @stability stable
     */
    resetOneOf(): void;
    /**
     * @stability stable
     */
    get oneOfInput(): AppUserSchemaPropertyOneOf[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
