import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AppUserSchemaConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema.html#app_id AppUserSchema#app_id}.
     *
     * @stability stable
     */
    readonly appId: string;
    /**
     * Custom Subschema enumerated value of a property of type array.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema.html#array_enum AppUserSchema#array_enum}
     *
     * @stability stable
     */
    readonly arrayEnum?: string[];
    /**
     * Subschema array type: string, number, integer, reference. Type field must be an array.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema.html#array_type AppUserSchema#array_type}
     *
     * @stability stable
     */
    readonly arrayType?: string;
    /**
     * Custom Subschema description.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema.html#description AppUserSchema#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Custom Subschema enumerated value of the property. see: developer.okta.com/docs/api/resources/schemas#user-profile-schema-property-object.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema.html#enum AppUserSchema#enum}
     *
     * @stability stable
     */
    readonly enum?: string[];
    /**
     * Subschema external name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema.html#external_name AppUserSchema#external_name}
     *
     * @stability stable
     */
    readonly externalName?: string;
    /**
     * Subschema external namespace.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema.html#external_namespace AppUserSchema#external_namespace}
     *
     * @stability stable
     */
    readonly externalNamespace?: string;
    /**
     * Subschema unique string identifier.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema.html#index AppUserSchema#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * SubSchema profile manager, if not set it will inherit its setting.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema.html#master AppUserSchema#master}
     *
     * @stability stable
     */
    readonly master?: string;
    /**
     * Subschema of type string maximum length.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema.html#max_length AppUserSchema#max_length}
     *
     * @stability stable
     */
    readonly maxLength?: number;
    /**
     * Subschema of type string minimum length.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema.html#min_length AppUserSchema#min_length}
     *
     * @stability stable
     */
    readonly minLength?: number;
    /**
     * SubSchema permissions: HIDE, READ_ONLY, or READ_WRITE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema.html#permissions AppUserSchema#permissions}
     *
     * @stability stable
     */
    readonly permissions?: string;
    /**
     * Whether the subschema is required.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema.html#required AppUserSchema#required}
     *
     * @stability stable
     */
    readonly required?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema.html#scope AppUserSchema#scope}.
     *
     * @stability stable
     */
    readonly scope?: string;
    /**
     * Subschema title (display name).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema.html#title AppUserSchema#title}
     *
     * @stability stable
     */
    readonly title: string;
    /**
     * Subschema type: string, boolean, number, integer, array, or object.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema.html#type AppUserSchema#type}
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Allows to assign attribute's group priority.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema.html#union AppUserSchema#union}
     *
     * @stability stable
     */
    readonly union?: boolean | cdktf.IResolvable;
    /**
     * Subschema unique restriction.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema.html#unique AppUserSchema#unique}
     *
     * @stability stable
     */
    readonly unique?: string;
    /**
     * Custom subschema user type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema.html#user_type AppUserSchema#user_type}
     *
     * @stability stable
     */
    readonly userType?: string;
    /**
     * array_one_of block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema.html#array_one_of AppUserSchema#array_one_of}
     *
     * @stability stable
     */
    readonly arrayOneOf?: AppUserSchemaArrayOneOf[];
    /**
     * one_of block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema.html#one_of AppUserSchema#one_of}
     *
     * @stability stable
     */
    readonly oneOf?: AppUserSchemaOneOf[];
}
/**
 * @stability stable
 */
export interface AppUserSchemaArrayOneOf {
    /**
     * Enum value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema.html#const AppUserSchema#const}
     *
     * @stability stable
     */
    readonly const: string;
    /**
     * Enum title.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema.html#title AppUserSchema#title}
     *
     * @stability stable
     */
    readonly title: string;
}
export declare function appUserSchemaArrayOneOfToTerraform(struct?: AppUserSchemaArrayOneOf): any;
/**
 * @stability stable
 */
export interface AppUserSchemaOneOf {
    /**
     * Enum value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema.html#const AppUserSchema#const}
     *
     * @stability stable
     */
    readonly const: string;
    /**
     * Enum title.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema.html#title AppUserSchema#title}
     *
     * @stability stable
     */
    readonly title: string;
}
export declare function appUserSchemaOneOfToTerraform(struct?: AppUserSchemaOneOf): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema.html okta_app_user_schema}.
 *
 * @stability stable
 */
export declare class AppUserSchema extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema.html okta_app_user_schema} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AppUserSchemaConfig);
    private _appId?;
    /**
     * @stability stable
     */
    get appId(): string;
    /**
     * @stability stable
     */
    set appId(value: string);
    /**
     * @stability stable
     */
    get appIdInput(): string | undefined;
    private _arrayEnum?;
    /**
     * @stability stable
     */
    get arrayEnum(): string[];
    /**
     * @stability stable
     */
    set arrayEnum(value: string[]);
    /**
     * @stability stable
     */
    resetArrayEnum(): void;
    /**
     * @stability stable
     */
    get arrayEnumInput(): string[] | undefined;
    private _arrayType?;
    /**
     * @stability stable
     */
    get arrayType(): string;
    /**
     * @stability stable
     */
    set arrayType(value: string);
    /**
     * @stability stable
     */
    resetArrayType(): void;
    /**
     * @stability stable
     */
    get arrayTypeInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _enum?;
    /**
     * @stability stable
     */
    get enum(): string[];
    /**
     * @stability stable
     */
    set enum(value: string[]);
    /**
     * @stability stable
     */
    resetEnum(): void;
    /**
     * @stability stable
     */
    get enumInput(): string[] | undefined;
    private _externalName?;
    /**
     * @stability stable
     */
    get externalName(): string;
    /**
     * @stability stable
     */
    set externalName(value: string);
    /**
     * @stability stable
     */
    resetExternalName(): void;
    /**
     * @stability stable
     */
    get externalNameInput(): string | undefined;
    private _externalNamespace?;
    /**
     * @stability stable
     */
    get externalNamespace(): string;
    /**
     * @stability stable
     */
    set externalNamespace(value: string);
    /**
     * @stability stable
     */
    resetExternalNamespace(): void;
    /**
     * @stability stable
     */
    get externalNamespaceInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _master?;
    /**
     * @stability stable
     */
    get master(): string;
    /**
     * @stability stable
     */
    set master(value: string);
    /**
     * @stability stable
     */
    resetMaster(): void;
    /**
     * @stability stable
     */
    get masterInput(): string | undefined;
    private _maxLength?;
    /**
     * @stability stable
     */
    get maxLength(): number;
    /**
     * @stability stable
     */
    set maxLength(value: number);
    /**
     * @stability stable
     */
    resetMaxLength(): void;
    /**
     * @stability stable
     */
    get maxLengthInput(): number | undefined;
    private _minLength?;
    /**
     * @stability stable
     */
    get minLength(): number;
    /**
     * @stability stable
     */
    set minLength(value: number);
    /**
     * @stability stable
     */
    resetMinLength(): void;
    /**
     * @stability stable
     */
    get minLengthInput(): number | undefined;
    private _permissions?;
    /**
     * @stability stable
     */
    get permissions(): string;
    /**
     * @stability stable
     */
    set permissions(value: string);
    /**
     * @stability stable
     */
    resetPermissions(): void;
    /**
     * @stability stable
     */
    get permissionsInput(): string | undefined;
    private _required?;
    /**
     * @stability stable
     */
    get required(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set required(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRequired(): void;
    /**
     * @stability stable
     */
    get requiredInput(): boolean | cdktf.IResolvable | undefined;
    private _scope?;
    /**
     * @stability stable
     */
    get scope(): string;
    /**
     * @stability stable
     */
    set scope(value: string);
    /**
     * @stability stable
     */
    resetScope(): void;
    /**
     * @stability stable
     */
    get scopeInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _union?;
    /**
     * @stability stable
     */
    get union(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set union(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetUnion(): void;
    /**
     * @stability stable
     */
    get unionInput(): boolean | cdktf.IResolvable | undefined;
    private _unique?;
    /**
     * @stability stable
     */
    get unique(): string;
    /**
     * @stability stable
     */
    set unique(value: string);
    /**
     * @stability stable
     */
    resetUnique(): void;
    /**
     * @stability stable
     */
    get uniqueInput(): string | undefined;
    private _userType?;
    /**
     * @stability stable
     */
    get userType(): string;
    /**
     * @stability stable
     */
    set userType(value: string);
    /**
     * @stability stable
     */
    resetUserType(): void;
    /**
     * @stability stable
     */
    get userTypeInput(): string | undefined;
    private _arrayOneOf?;
    /**
     * @stability stable
     */
    get arrayOneOf(): AppUserSchemaArrayOneOf[];
    /**
     * @stability stable
     */
    set arrayOneOf(value: AppUserSchemaArrayOneOf[]);
    /**
     * @stability stable
     */
    resetArrayOneOf(): void;
    /**
     * @stability stable
     */
    get arrayOneOfInput(): AppUserSchemaArrayOneOf[] | undefined;
    private _oneOf?;
    /**
     * @stability stable
     */
    get oneOf(): AppUserSchemaOneOf[];
    /**
     * @stability stable
     */
    set oneOf(value: AppUserSchemaOneOf[]);
    /**
     * @stability stable
     */
    resetOneOf(): void;
    /**
     * @stability stable
     */
    get oneOfInput(): AppUserSchemaOneOf[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
