import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AppUserConfig extends cdktf.TerraformMetaArguments {
    /**
     * App to associate user with.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user.html#app_id AppUser#app_id}
     *
     * @stability stable
     */
    readonly appId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user.html#password AppUser#password}.
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user.html#profile AppUser#profile}.
     *
     * @stability stable
     */
    readonly profile?: string;
    /**
     * Retain the user assignment on destroy.
     *
     * If set to true, the resource will be removed from state but not from the Okta app.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user.html#retain_assignment AppUser#retain_assignment}
     *
     * @stability stable
     */
    readonly retainAssignment?: boolean | cdktf.IResolvable;
    /**
     * User associated with the application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user.html#user_id AppUser#user_id}
     *
     * @stability stable
     */
    readonly userId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user.html#username AppUser#username}.
     *
     * @stability stable
     */
    readonly username?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/app_user.html okta_app_user}.
 *
 * @stability stable
 */
export declare class AppUser extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/app_user.html okta_app_user} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AppUserConfig);
    private _appId?;
    /**
     * @stability stable
     */
    get appId(): string;
    /**
     * @stability stable
     */
    set appId(value: string);
    /**
     * @stability stable
     */
    get appIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get hasSharedUsername(): any;
    /**
     * @stability stable
     */
    get id(): string;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    resetPassword(): void;
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _profile?;
    /**
     * @stability stable
     */
    get profile(): string;
    /**
     * @stability stable
     */
    set profile(value: string);
    /**
     * @stability stable
     */
    resetProfile(): void;
    /**
     * @stability stable
     */
    get profileInput(): string | undefined;
    private _retainAssignment?;
    /**
     * @stability stable
     */
    get retainAssignment(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set retainAssignment(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRetainAssignment(): void;
    /**
     * @stability stable
     */
    get retainAssignmentInput(): boolean | cdktf.IResolvable | undefined;
    private _userId?;
    /**
     * @stability stable
     */
    get userId(): string;
    /**
     * @stability stable
     */
    set userId(value: string);
    /**
     * @stability stable
     */
    get userIdInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    resetUsername(): void;
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
