import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AuthServerClaimDefaultConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_claim_default.html#always_include_in_token AuthServerClaimDefault#always_include_in_token}.
     *
     * @stability stable
     */
    readonly alwaysIncludeInToken?: boolean | cdktf.IResolvable;
    /**
     * Auth server ID.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_claim_default.html#auth_server_id AuthServerClaimDefault#auth_server_id}
     *
     * @stability stable
     */
    readonly authServerId: string;
    /**
     * Default auth server claim name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_claim_default.html#name AuthServerClaimDefault#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_claim_default.html#value AuthServerClaimDefault#value}.
     *
     * @stability stable
     */
    readonly value?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/auth_server_claim_default.html okta_auth_server_claim_default}.
 *
 * @stability stable
 */
export declare class AuthServerClaimDefault extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/auth_server_claim_default.html okta_auth_server_claim_default} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AuthServerClaimDefaultConfig);
    private _alwaysIncludeInToken?;
    /**
     * @stability stable
     */
    get alwaysIncludeInToken(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set alwaysIncludeInToken(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAlwaysIncludeInToken(): void;
    /**
     * @stability stable
     */
    get alwaysIncludeInTokenInput(): boolean | cdktf.IResolvable | undefined;
    private _authServerId?;
    /**
     * @stability stable
     */
    get authServerId(): string;
    /**
     * @stability stable
     */
    set authServerId(value: string);
    /**
     * @stability stable
     */
    get authServerIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get claimType(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get scopes(): string[];
    /**
     * @stability stable
     */
    get status(): string;
    private _value?;
    /**
     * @stability stable
     */
    get value(): string;
    /**
     * @stability stable
     */
    set value(value: string);
    /**
     * @stability stable
     */
    resetValue(): void;
    /**
     * @stability stable
     */
    get valueInput(): string | undefined;
    /**
     * @stability stable
     */
    get valueType(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
