import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AuthServerClaimConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_claim.html#always_include_in_token AuthServerClaim#always_include_in_token}.
     *
     * @stability stable
     */
    readonly alwaysIncludeInToken?: boolean | cdktf.IResolvable;
    /**
     * Auth server ID.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_claim.html#auth_server_id AuthServerClaim#auth_server_id}
     *
     * @stability stable
     */
    readonly authServerId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_claim.html#claim_type AuthServerClaim#claim_type}.
     *
     * @stability stable
     */
    readonly claimType: string;
    /**
     * Required when value_type is GROUPS.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_claim.html#group_filter_type AuthServerClaim#group_filter_type}
     *
     * @stability stable
     */
    readonly groupFilterType?: string;
    /**
     * Auth server claim name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_claim.html#name AuthServerClaim#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Auth server claim list of scopes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_claim.html#scopes AuthServerClaim#scopes}
     *
     * @stability stable
     */
    readonly scopes?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_claim.html#status AuthServerClaim#status}.
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_claim.html#value AuthServerClaim#value}.
     *
     * @stability stable
     */
    readonly value: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_claim.html#value_type AuthServerClaim#value_type}.
     *
     * @stability stable
     */
    readonly valueType?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/auth_server_claim.html okta_auth_server_claim}.
 *
 * @stability stable
 */
export declare class AuthServerClaim extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/auth_server_claim.html okta_auth_server_claim} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AuthServerClaimConfig);
    private _alwaysIncludeInToken?;
    /**
     * @stability stable
     */
    get alwaysIncludeInToken(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set alwaysIncludeInToken(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAlwaysIncludeInToken(): void;
    /**
     * @stability stable
     */
    get alwaysIncludeInTokenInput(): boolean | cdktf.IResolvable | undefined;
    private _authServerId?;
    /**
     * @stability stable
     */
    get authServerId(): string;
    /**
     * @stability stable
     */
    set authServerId(value: string);
    /**
     * @stability stable
     */
    get authServerIdInput(): string | undefined;
    private _claimType?;
    /**
     * @stability stable
     */
    get claimType(): string;
    /**
     * @stability stable
     */
    set claimType(value: string);
    /**
     * @stability stable
     */
    get claimTypeInput(): string | undefined;
    private _groupFilterType?;
    /**
     * @stability stable
     */
    get groupFilterType(): string;
    /**
     * @stability stable
     */
    set groupFilterType(value: string);
    /**
     * @stability stable
     */
    resetGroupFilterType(): void;
    /**
     * @stability stable
     */
    get groupFilterTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _scopes?;
    /**
     * @stability stable
     */
    get scopes(): string[];
    /**
     * @stability stable
     */
    set scopes(value: string[]);
    /**
     * @stability stable
     */
    resetScopes(): void;
    /**
     * @stability stable
     */
    get scopesInput(): string[] | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    set status(value: string);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    private _value?;
    /**
     * @stability stable
     */
    get value(): string;
    /**
     * @stability stable
     */
    set value(value: string);
    /**
     * @stability stable
     */
    get valueInput(): string | undefined;
    private _valueType?;
    /**
     * @stability stable
     */
    get valueType(): string;
    /**
     * @stability stable
     */
    set valueType(value: string);
    /**
     * @stability stable
     */
    resetValueType(): void;
    /**
     * @stability stable
     */
    get valueTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
