import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AuthServerDefaultConfig extends cdktf.TerraformMetaArguments {
    /**
     * Currently Okta only supports a single value here.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_default.html#audiences AuthServerDefault#audiences}
     *
     * @stability stable
     */
    readonly audiences?: string[];
    /**
     * Credential rotation mode, in many cases you cannot set this to MANUAL, the API will ignore the value and you will get a perpetual diff.
     *
     * This should rarely be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_default.html#credentials_rotation_mode AuthServerDefault#credentials_rotation_mode}
     *
     * @stability stable
     */
    readonly credentialsRotationMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_default.html#description AuthServerDefault#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * *Early Access Property*.
     *
     * Indicates which value is specified in the issuer of the tokens that a Custom Authorization Server returns: the original Okta org domain URL or a custom domain URL
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_default.html#issuer_mode AuthServerDefault#issuer_mode}
     *
     * @stability stable
     */
    readonly issuerMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_default.html#name AuthServerDefault#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_default.html#status AuthServerDefault#status}.
     *
     * @stability stable
     */
    readonly status?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/auth_server_default.html okta_auth_server_default}.
 *
 * @stability stable
 */
export declare class AuthServerDefault extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/auth_server_default.html okta_auth_server_default} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AuthServerDefaultConfig);
    private _audiences?;
    /**
     * @stability stable
     */
    get audiences(): string[];
    /**
     * @stability stable
     */
    set audiences(value: string[]);
    /**
     * @stability stable
     */
    resetAudiences(): void;
    /**
     * @stability stable
     */
    get audiencesInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get credentialsLastRotated(): string;
    /**
     * @stability stable
     */
    get credentialsNextRotation(): string;
    private _credentialsRotationMode?;
    /**
     * @stability stable
     */
    get credentialsRotationMode(): string;
    /**
     * @stability stable
     */
    set credentialsRotationMode(value: string);
    /**
     * @stability stable
     */
    resetCredentialsRotationMode(): void;
    /**
     * @stability stable
     */
    get credentialsRotationModeInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get issuer(): string;
    private _issuerMode?;
    /**
     * @stability stable
     */
    get issuerMode(): string;
    /**
     * @stability stable
     */
    set issuerMode(value: string);
    /**
     * @stability stable
     */
    resetIssuerMode(): void;
    /**
     * @stability stable
     */
    get issuerModeInput(): string | undefined;
    /**
     * @stability stable
     */
    get kid(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    set status(value: string);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
