import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AuthServerPolicyRuleConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy_rule.html#access_token_lifetime_minutes AuthServerPolicyRule#access_token_lifetime_minutes}.
     *
     * @stability stable
     */
    readonly accessTokenLifetimeMinutes?: number;
    /**
     * Auth server ID.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy_rule.html#auth_server_id AuthServerPolicyRule#auth_server_id}
     *
     * @stability stable
     */
    readonly authServerId: string;
    /**
     * Accepted grant type values: authorization_code, implicit, password, client_credentials.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy_rule.html#grant_type_whitelist AuthServerPolicyRule#grant_type_whitelist}
     *
     * @stability stable
     */
    readonly grantTypeWhitelist: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy_rule.html#group_blacklist AuthServerPolicyRule#group_blacklist}.
     *
     * @stability stable
     */
    readonly groupBlacklist?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy_rule.html#group_whitelist AuthServerPolicyRule#group_whitelist}.
     *
     * @stability stable
     */
    readonly groupWhitelist?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy_rule.html#inline_hook_id AuthServerPolicyRule#inline_hook_id}.
     *
     * @stability stable
     */
    readonly inlineHookId?: string;
    /**
     * Auth server policy rule name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy_rule.html#name AuthServerPolicyRule#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Auth server policy ID.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy_rule.html#policy_id AuthServerPolicyRule#policy_id}
     *
     * @stability stable
     */
    readonly policyId: string;
    /**
     * Priority of the auth server policy rule.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy_rule.html#priority AuthServerPolicyRule#priority}
     *
     * @stability stable
     */
    readonly priority: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy_rule.html#refresh_token_lifetime_minutes AuthServerPolicyRule#refresh_token_lifetime_minutes}.
     *
     * @stability stable
     */
    readonly refreshTokenLifetimeMinutes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy_rule.html#refresh_token_window_minutes AuthServerPolicyRule#refresh_token_window_minutes}.
     *
     * @stability stable
     */
    readonly refreshTokenWindowMinutes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy_rule.html#scope_whitelist AuthServerPolicyRule#scope_whitelist}.
     *
     * @stability stable
     */
    readonly scopeWhitelist?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy_rule.html#status AuthServerPolicyRule#status}.
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * Auth server policy rule type, unlikely this will be anything other then the default.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy_rule.html#type AuthServerPolicyRule#type}
     *
     * @stability stable
     */
    readonly type?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy_rule.html#user_blacklist AuthServerPolicyRule#user_blacklist}.
     *
     * @stability stable
     */
    readonly userBlacklist?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy_rule.html#user_whitelist AuthServerPolicyRule#user_whitelist}.
     *
     * @stability stable
     */
    readonly userWhitelist?: string[];
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy_rule.html okta_auth_server_policy_rule}.
 *
 * @stability stable
 */
export declare class AuthServerPolicyRule extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy_rule.html okta_auth_server_policy_rule} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AuthServerPolicyRuleConfig);
    private _accessTokenLifetimeMinutes?;
    /**
     * @stability stable
     */
    get accessTokenLifetimeMinutes(): number;
    /**
     * @stability stable
     */
    set accessTokenLifetimeMinutes(value: number);
    /**
     * @stability stable
     */
    resetAccessTokenLifetimeMinutes(): void;
    /**
     * @stability stable
     */
    get accessTokenLifetimeMinutesInput(): number | undefined;
    private _authServerId?;
    /**
     * @stability stable
     */
    get authServerId(): string;
    /**
     * @stability stable
     */
    set authServerId(value: string);
    /**
     * @stability stable
     */
    get authServerIdInput(): string | undefined;
    private _grantTypeWhitelist?;
    /**
     * @stability stable
     */
    get grantTypeWhitelist(): string[];
    /**
     * @stability stable
     */
    set grantTypeWhitelist(value: string[]);
    /**
     * @stability stable
     */
    get grantTypeWhitelistInput(): string[] | undefined;
    private _groupBlacklist?;
    /**
     * @stability stable
     */
    get groupBlacklist(): string[];
    /**
     * @stability stable
     */
    set groupBlacklist(value: string[]);
    /**
     * @stability stable
     */
    resetGroupBlacklist(): void;
    /**
     * @stability stable
     */
    get groupBlacklistInput(): string[] | undefined;
    private _groupWhitelist?;
    /**
     * @stability stable
     */
    get groupWhitelist(): string[];
    /**
     * @stability stable
     */
    set groupWhitelist(value: string[]);
    /**
     * @stability stable
     */
    resetGroupWhitelist(): void;
    /**
     * @stability stable
     */
    get groupWhitelistInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _inlineHookId?;
    /**
     * @stability stable
     */
    get inlineHookId(): string;
    /**
     * @stability stable
     */
    set inlineHookId(value: string);
    /**
     * @stability stable
     */
    resetInlineHookId(): void;
    /**
     * @stability stable
     */
    get inlineHookIdInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _policyId?;
    /**
     * @stability stable
     */
    get policyId(): string;
    /**
     * @stability stable
     */
    set policyId(value: string);
    /**
     * @stability stable
     */
    get policyIdInput(): string | undefined;
    private _priority?;
    /**
     * @stability stable
     */
    get priority(): number;
    /**
     * @stability stable
     */
    set priority(value: number);
    /**
     * @stability stable
     */
    get priorityInput(): number | undefined;
    private _refreshTokenLifetimeMinutes?;
    /**
     * @stability stable
     */
    get refreshTokenLifetimeMinutes(): number;
    /**
     * @stability stable
     */
    set refreshTokenLifetimeMinutes(value: number);
    /**
     * @stability stable
     */
    resetRefreshTokenLifetimeMinutes(): void;
    /**
     * @stability stable
     */
    get refreshTokenLifetimeMinutesInput(): number | undefined;
    private _refreshTokenWindowMinutes?;
    /**
     * @stability stable
     */
    get refreshTokenWindowMinutes(): number;
    /**
     * @stability stable
     */
    set refreshTokenWindowMinutes(value: number);
    /**
     * @stability stable
     */
    resetRefreshTokenWindowMinutes(): void;
    /**
     * @stability stable
     */
    get refreshTokenWindowMinutesInput(): number | undefined;
    private _scopeWhitelist?;
    /**
     * @stability stable
     */
    get scopeWhitelist(): string[];
    /**
     * @stability stable
     */
    set scopeWhitelist(value: string[]);
    /**
     * @stability stable
     */
    resetScopeWhitelist(): void;
    /**
     * @stability stable
     */
    get scopeWhitelistInput(): string[] | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    set status(value: string);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    resetType(): void;
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _userBlacklist?;
    /**
     * @stability stable
     */
    get userBlacklist(): string[];
    /**
     * @stability stable
     */
    set userBlacklist(value: string[]);
    /**
     * @stability stable
     */
    resetUserBlacklist(): void;
    /**
     * @stability stable
     */
    get userBlacklistInput(): string[] | undefined;
    private _userWhitelist?;
    /**
     * @stability stable
     */
    get userWhitelist(): string[];
    /**
     * @stability stable
     */
    set userWhitelist(value: string[]);
    /**
     * @stability stable
     */
    resetUserWhitelist(): void;
    /**
     * @stability stable
     */
    get userWhitelistInput(): string[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
