import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AuthServerPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy.html#auth_server_id AuthServerPolicy#auth_server_id}.
     *
     * @stability stable
     */
    readonly authServerId: string;
    /**
     * Use ["ALL_CLIENTS"] when unsure.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy.html#client_whitelist AuthServerPolicy#client_whitelist}
     *
     * @stability stable
     */
    readonly clientWhitelist: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy.html#description AuthServerPolicy#description}.
     *
     * @stability stable
     */
    readonly description: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy.html#name AuthServerPolicy#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Priority of the auth server policy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy.html#priority AuthServerPolicy#priority}
     *
     * @stability stable
     */
    readonly priority: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy.html#status AuthServerPolicy#status}.
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * Auth server policy type, unlikely this will be anything other then the default.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy.html#type AuthServerPolicy#type}
     *
     * @stability stable
     */
    readonly type?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy.html okta_auth_server_policy}.
 *
 * @stability stable
 */
export declare class AuthServerPolicy extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy.html okta_auth_server_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AuthServerPolicyConfig);
    private _authServerId?;
    /**
     * @stability stable
     */
    get authServerId(): string;
    /**
     * @stability stable
     */
    set authServerId(value: string);
    /**
     * @stability stable
     */
    get authServerIdInput(): string | undefined;
    private _clientWhitelist?;
    /**
     * @stability stable
     */
    get clientWhitelist(): string[];
    /**
     * @stability stable
     */
    set clientWhitelist(value: string[]);
    /**
     * @stability stable
     */
    get clientWhitelistInput(): string[] | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _priority?;
    /**
     * @stability stable
     */
    get priority(): number;
    /**
     * @stability stable
     */
    set priority(value: number);
    /**
     * @stability stable
     */
    get priorityInput(): number | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    set status(value: string);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    resetType(): void;
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
