import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AuthServerScopeConfig extends cdktf.TerraformMetaArguments {
    /**
     * Auth server ID.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_scope.html#auth_server_id AuthServerScope#auth_server_id}
     *
     * @stability stable
     */
    readonly authServerId: string;
    /**
     * EA Feature and thus it is simply ignored if the feature is off.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_scope.html#consent AuthServerScope#consent}
     *
     * @stability stable
     */
    readonly consent?: string;
    /**
     * A default scope will be returned in an access token when the client omits the scope parameter in a token request, provided this scope is allowed as part of the access policy rule.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_scope.html#default AuthServerScope#default}
     *
     * @stability stable
     */
    readonly default?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_scope.html#description AuthServerScope#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Name of the end user displayed in a consent dialog box.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_scope.html#display_name AuthServerScope#display_name}
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * Whether to publish metadata or not, matching API type despite the fact it could just be a boolean.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_scope.html#metadata_publish AuthServerScope#metadata_publish}
     *
     * @stability stable
     */
    readonly metadataPublish?: string;
    /**
     * Auth server scope name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_scope.html#name AuthServerScope#name}
     *
     * @stability stable
     */
    readonly name: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/auth_server_scope.html okta_auth_server_scope}.
 *
 * @stability stable
 */
export declare class AuthServerScope extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/auth_server_scope.html okta_auth_server_scope} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AuthServerScopeConfig);
    private _authServerId?;
    /**
     * @stability stable
     */
    get authServerId(): string;
    /**
     * @stability stable
     */
    set authServerId(value: string);
    /**
     * @stability stable
     */
    get authServerIdInput(): string | undefined;
    private _consent?;
    /**
     * @stability stable
     */
    get consent(): string;
    /**
     * @stability stable
     */
    set consent(value: string);
    /**
     * @stability stable
     */
    resetConsent(): void;
    /**
     * @stability stable
     */
    get consentInput(): string | undefined;
    private _default?;
    /**
     * @stability stable
     */
    get default(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set default(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDefault(): void;
    /**
     * @stability stable
     */
    get defaultInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _metadataPublish?;
    /**
     * @stability stable
     */
    get metadataPublish(): string;
    /**
     * @stability stable
     */
    set metadataPublish(value: string);
    /**
     * @stability stable
     */
    resetMetadataPublish(): void;
    /**
     * @stability stable
     */
    get metadataPublishInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
