import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AuthenticatorConfig extends cdktf.TerraformMetaArguments {
    /**
     * A human-readable string that identifies the Authenticator.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/authenticator.html#key Authenticator#key}
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Display name of the Authenticator.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/authenticator.html#name Authenticator#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The RADIUS server port (for example 1812). This is defined when the On-Prem RADIUS server is configured.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/authenticator.html#provider_auth_port Authenticator#provider_auth_port}
     *
     * @stability stable
     */
    readonly providerAuthPort?: number;
    /**
     * Server host name or IP address.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/authenticator.html#provider_hostname Authenticator#provider_hostname}
     *
     * @stability stable
     */
    readonly providerHostname?: string;
    /**
     * An authentication key that must be defined when the RADIUS server is configured, and must be the same on both the RADIUS client and server.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/authenticator.html#provider_shared_secret Authenticator#provider_shared_secret}
     *
     * @stability stable
     */
    readonly providerSharedSecret?: string;
    /**
     * Format expected by the provider.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/authenticator.html#provider_user_name_template Authenticator#provider_user_name_template}
     *
     * @stability stable
     */
    readonly providerUserNameTemplate?: string;
    /**
     * Authenticator settings in JSON format.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/authenticator.html#settings Authenticator#settings}
     *
     * @stability stable
     */
    readonly settings?: string;
    /**
     * Authenticator status: ACTIVE or INACTIVE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/authenticator.html#status Authenticator#status}
     *
     * @stability stable
     */
    readonly status?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/authenticator.html okta_authenticator}.
 *
 * @stability stable
 */
export declare class Authenticator extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/authenticator.html okta_authenticator} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AuthenticatorConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _key?;
    /**
     * @stability stable
     */
    get key(): string;
    /**
     * @stability stable
     */
    set key(value: string);
    /**
     * @stability stable
     */
    get keyInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _providerAuthPort?;
    /**
     * @stability stable
     */
    get providerAuthPort(): number;
    /**
     * @stability stable
     */
    set providerAuthPort(value: number);
    /**
     * @stability stable
     */
    resetProviderAuthPort(): void;
    /**
     * @stability stable
     */
    get providerAuthPortInput(): number | undefined;
    private _providerHostname?;
    /**
     * @stability stable
     */
    get providerHostname(): string;
    /**
     * @stability stable
     */
    set providerHostname(value: string);
    /**
     * @stability stable
     */
    resetProviderHostname(): void;
    /**
     * @stability stable
     */
    get providerHostnameInput(): string | undefined;
    /**
     * @stability stable
     */
    get providerInstanceId(): string;
    private _providerSharedSecret?;
    /**
     * @stability stable
     */
    get providerSharedSecret(): string;
    /**
     * @stability stable
     */
    set providerSharedSecret(value: string);
    /**
     * @stability stable
     */
    resetProviderSharedSecret(): void;
    /**
     * @stability stable
     */
    get providerSharedSecretInput(): string | undefined;
    /**
     * @stability stable
     */
    get providerType(): string;
    private _providerUserNameTemplate?;
    /**
     * @stability stable
     */
    get providerUserNameTemplate(): string;
    /**
     * @stability stable
     */
    set providerUserNameTemplate(value: string);
    /**
     * @stability stable
     */
    resetProviderUserNameTemplate(): void;
    /**
     * @stability stable
     */
    get providerUserNameTemplateInput(): string | undefined;
    private _settings?;
    /**
     * @stability stable
     */
    get settings(): string;
    /**
     * @stability stable
     */
    set settings(value: string);
    /**
     * @stability stable
     */
    resetSettings(): void;
    /**
     * @stability stable
     */
    get settingsInput(): string | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    set status(value: string);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
