import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface BehaviorConfig extends cdktf.TerraformMetaArguments {
    /**
     * Determines the method and level of detail used to evaluate the behavior.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/behavior.html#location_granularity_type Behavior#location_granularity_type}
     *
     * @stability stable
     */
    readonly locationGranularityType?: string;
    /**
     * Name of the behavior.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/behavior.html#name Behavior#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The number of recent authentications used to evaluate the behavior.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/behavior.html#number_of_authentications Behavior#number_of_authentications}
     *
     * @stability stable
     */
    readonly numberOfAuthentications?: number;
    /**
     * Radius from location (in kilometers).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/behavior.html#radius_from_location Behavior#radius_from_location}
     *
     * @stability stable
     */
    readonly radiusFromLocation?: number;
    /**
     * Behavior status: ACTIVE or INACTIVE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/behavior.html#status Behavior#status}
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * Behavior type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/behavior.html#type Behavior#type}
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Velocity (in kilometers per hour).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/behavior.html#velocity Behavior#velocity}
     *
     * @stability stable
     */
    readonly velocity?: number;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/behavior.html okta_behavior}.
 *
 * @stability stable
 */
export declare class Behavior extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/behavior.html okta_behavior} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: BehaviorConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _locationGranularityType?;
    /**
     * @stability stable
     */
    get locationGranularityType(): string;
    /**
     * @stability stable
     */
    set locationGranularityType(value: string);
    /**
     * @stability stable
     */
    resetLocationGranularityType(): void;
    /**
     * @stability stable
     */
    get locationGranularityTypeInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _numberOfAuthentications?;
    /**
     * @stability stable
     */
    get numberOfAuthentications(): number;
    /**
     * @stability stable
     */
    set numberOfAuthentications(value: number);
    /**
     * @stability stable
     */
    resetNumberOfAuthentications(): void;
    /**
     * @stability stable
     */
    get numberOfAuthenticationsInput(): number | undefined;
    private _radiusFromLocation?;
    /**
     * @stability stable
     */
    get radiusFromLocation(): number;
    /**
     * @stability stable
     */
    set radiusFromLocation(value: number);
    /**
     * @stability stable
     */
    resetRadiusFromLocation(): void;
    /**
     * @stability stable
     */
    get radiusFromLocationInput(): number | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    set status(value: string);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _velocity?;
    /**
     * @stability stable
     */
    get velocity(): number;
    /**
     * @stability stable
     */
    set velocity(value: number);
    /**
     * @stability stable
     */
    resetVelocity(): void;
    /**
     * @stability stable
     */
    get velocityInput(): number | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
