import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface BookmarkAppConfig extends cdktf.TerraformMetaArguments {
    /**
     * Custom error page URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/bookmark_app.html#accessibility_error_redirect_url BookmarkApp#accessibility_error_redirect_url}
     *
     * @stability stable
     */
    readonly accessibilityErrorRedirectUrl?: string;
    /**
     * Custom login page URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/bookmark_app.html#accessibility_login_redirect_url BookmarkApp#accessibility_login_redirect_url}
     *
     * @stability stable
     */
    readonly accessibilityLoginRedirectUrl?: string;
    /**
     * Enable self service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/bookmark_app.html#accessibility_self_service BookmarkApp#accessibility_self_service}
     *
     * @stability stable
     */
    readonly accessibilitySelfService?: boolean | cdktf.IResolvable;
    /**
     * Application notes for admins.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/bookmark_app.html#admin_note BookmarkApp#admin_note}
     *
     * @stability stable
     */
    readonly adminNote?: string;
    /**
     * Displays specific appLinks for the app.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/bookmark_app.html#app_links_json BookmarkApp#app_links_json}
     *
     * @stability stable
     */
    readonly appLinksJson?: string;
    /**
     * Display auto submit toolbar.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/bookmark_app.html#auto_submit_toolbar BookmarkApp#auto_submit_toolbar}
     *
     * @stability stable
     */
    readonly autoSubmitToolbar?: boolean | cdktf.IResolvable;
    /**
     * Application notes for end users.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/bookmark_app.html#enduser_note BookmarkApp#enduser_note}
     *
     * @stability stable
     */
    readonly enduserNote?: string;
    /**
     * Groups associated with the application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/bookmark_app.html#groups BookmarkApp#groups}
     *
     * @stability stable
     */
    readonly groups?: string[];
    /**
     * Do not display application icon on mobile app.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/bookmark_app.html#hide_ios BookmarkApp#hide_ios}
     *
     * @stability stable
     */
    readonly hideIos?: boolean | cdktf.IResolvable;
    /**
     * Do not display application icon to users.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/bookmark_app.html#hide_web BookmarkApp#hide_web}
     *
     * @stability stable
     */
    readonly hideWeb?: boolean | cdktf.IResolvable;
    /**
     * Pretty name of app.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/bookmark_app.html#label BookmarkApp#label}
     *
     * @stability stable
     */
    readonly label: string;
    /**
     * Local path to logo of the application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/bookmark_app.html#logo BookmarkApp#logo}
     *
     * @stability stable
     */
    readonly logo?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/bookmark_app.html#request_integration BookmarkApp#request_integration}.
     *
     * @stability stable
     */
    readonly requestIntegration?: boolean | cdktf.IResolvable;
    /**
     * Ignore groups sync. This is a temporary solution until 'groups' field is supported in all the app-like resources.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/bookmark_app.html#skip_groups BookmarkApp#skip_groups}
     *
     * @stability stable
     */
    readonly skipGroups?: boolean | cdktf.IResolvable;
    /**
     * Ignore users sync. This is a temporary solution until 'users' field is supported in all the app-like resources.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/bookmark_app.html#skip_users BookmarkApp#skip_users}
     *
     * @stability stable
     */
    readonly skipUsers?: boolean | cdktf.IResolvable;
    /**
     * Status of application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/bookmark_app.html#status BookmarkApp#status}
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/bookmark_app.html#url BookmarkApp#url}.
     *
     * @stability stable
     */
    readonly url: string;
    /**
     * users block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/bookmark_app.html#users BookmarkApp#users}
     *
     * @stability stable
     */
    readonly users?: BookmarkAppUsers[];
}
/**
 * @stability stable
 */
export interface BookmarkAppUsers {
    /**
     * User ID.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/bookmark_app.html#id BookmarkApp#id}
     *
     * @stability stable
     */
    readonly id?: string;
    /**
     * Password for user application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/bookmark_app.html#password BookmarkApp#password}
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * Username for user.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/bookmark_app.html#username BookmarkApp#username}
     *
     * @stability stable
     */
    readonly username?: string;
}
export declare function bookmarkAppUsersToTerraform(struct?: BookmarkAppUsers): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/bookmark_app.html okta_bookmark_app}.
 *
 * @stability stable
 */
export declare class BookmarkApp extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/bookmark_app.html okta_bookmark_app} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: BookmarkAppConfig);
    private _accessibilityErrorRedirectUrl?;
    /**
     * @stability stable
     */
    get accessibilityErrorRedirectUrl(): string;
    /**
     * @stability stable
     */
    set accessibilityErrorRedirectUrl(value: string);
    /**
     * @stability stable
     */
    resetAccessibilityErrorRedirectUrl(): void;
    /**
     * @stability stable
     */
    get accessibilityErrorRedirectUrlInput(): string | undefined;
    private _accessibilityLoginRedirectUrl?;
    /**
     * @stability stable
     */
    get accessibilityLoginRedirectUrl(): string;
    /**
     * @stability stable
     */
    set accessibilityLoginRedirectUrl(value: string);
    /**
     * @stability stable
     */
    resetAccessibilityLoginRedirectUrl(): void;
    /**
     * @stability stable
     */
    get accessibilityLoginRedirectUrlInput(): string | undefined;
    private _accessibilitySelfService?;
    /**
     * @stability stable
     */
    get accessibilitySelfService(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set accessibilitySelfService(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAccessibilitySelfService(): void;
    /**
     * @stability stable
     */
    get accessibilitySelfServiceInput(): boolean | cdktf.IResolvable | undefined;
    private _adminNote?;
    /**
     * @stability stable
     */
    get adminNote(): string;
    /**
     * @stability stable
     */
    set adminNote(value: string);
    /**
     * @stability stable
     */
    resetAdminNote(): void;
    /**
     * @stability stable
     */
    get adminNoteInput(): string | undefined;
    private _appLinksJson?;
    /**
     * @stability stable
     */
    get appLinksJson(): string;
    /**
     * @stability stable
     */
    set appLinksJson(value: string);
    /**
     * @stability stable
     */
    resetAppLinksJson(): void;
    /**
     * @stability stable
     */
    get appLinksJsonInput(): string | undefined;
    private _autoSubmitToolbar?;
    /**
     * @stability stable
     */
    get autoSubmitToolbar(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set autoSubmitToolbar(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAutoSubmitToolbar(): void;
    /**
     * @stability stable
     */
    get autoSubmitToolbarInput(): boolean | cdktf.IResolvable | undefined;
    private _enduserNote?;
    /**
     * @stability stable
     */
    get enduserNote(): string;
    /**
     * @stability stable
     */
    set enduserNote(value: string);
    /**
     * @stability stable
     */
    resetEnduserNote(): void;
    /**
     * @stability stable
     */
    get enduserNoteInput(): string | undefined;
    private _groups?;
    /**
     * @stability stable
     */
    get groups(): string[];
    /**
     * @stability stable
     */
    set groups(value: string[]);
    /**
     * @stability stable
     */
    resetGroups(): void;
    /**
     * @stability stable
     */
    get groupsInput(): string[] | undefined;
    private _hideIos?;
    /**
     * @stability stable
     */
    get hideIos(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set hideIos(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHideIos(): void;
    /**
     * @stability stable
     */
    get hideIosInput(): boolean | cdktf.IResolvable | undefined;
    private _hideWeb?;
    /**
     * @stability stable
     */
    get hideWeb(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set hideWeb(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHideWeb(): void;
    /**
     * @stability stable
     */
    get hideWebInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _label?;
    /**
     * @stability stable
     */
    get label(): string;
    /**
     * @stability stable
     */
    set label(value: string);
    /**
     * @stability stable
     */
    get labelInput(): string | undefined;
    private _logo?;
    /**
     * @stability stable
     */
    get logo(): string;
    /**
     * @stability stable
     */
    set logo(value: string);
    /**
     * @stability stable
     */
    resetLogo(): void;
    /**
     * @stability stable
     */
    get logoInput(): string | undefined;
    /**
     * @stability stable
     */
    get logoUrl(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _requestIntegration?;
    /**
     * @stability stable
     */
    get requestIntegration(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set requestIntegration(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRequestIntegration(): void;
    /**
     * @stability stable
     */
    get requestIntegrationInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get signOnMode(): string;
    private _skipGroups?;
    /**
     * @stability stable
     */
    get skipGroups(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set skipGroups(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSkipGroups(): void;
    /**
     * @stability stable
     */
    get skipGroupsInput(): boolean | cdktf.IResolvable | undefined;
    private _skipUsers?;
    /**
     * @stability stable
     */
    get skipUsers(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set skipUsers(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSkipUsers(): void;
    /**
     * @stability stable
     */
    get skipUsersInput(): boolean | cdktf.IResolvable | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    set status(value: string);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    private _url?;
    /**
     * @stability stable
     */
    get url(): string;
    /**
     * @stability stable
     */
    set url(value: string);
    /**
     * @stability stable
     */
    get urlInput(): string | undefined;
    private _users?;
    /**
     * @stability stable
     */
    get users(): BookmarkAppUsers[];
    /**
     * @stability stable
     */
    set users(value: BookmarkAppUsers[]);
    /**
     * @stability stable
     */
    resetUsers(): void;
    /**
     * @stability stable
     */
    get usersInput(): BookmarkAppUsers[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
