import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CaptchaOrgWideSettingsConfig extends cdktf.TerraformMetaArguments {
    /**
     * ID of the CAPTCHA.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/captcha_org_wide_settings.html#captcha_id CaptchaOrgWideSettings#captcha_id}
     *
     * @stability stable
     */
    readonly captchaId?: string;
    /**
     * Set of pages that have CAPTCHA enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/captcha_org_wide_settings.html#enabled_for CaptchaOrgWideSettings#enabled_for}
     *
     * @stability stable
     */
    readonly enabledFor?: string[];
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/captcha_org_wide_settings.html okta_captcha_org_wide_settings}.
 *
 * @stability stable
 */
export declare class CaptchaOrgWideSettings extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/captcha_org_wide_settings.html okta_captcha_org_wide_settings} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: CaptchaOrgWideSettingsConfig);
    private _captchaId?;
    /**
     * @stability stable
     */
    get captchaId(): string;
    /**
     * @stability stable
     */
    set captchaId(value: string);
    /**
     * @stability stable
     */
    resetCaptchaId(): void;
    /**
     * @stability stable
     */
    get captchaIdInput(): string | undefined;
    private _enabledFor?;
    /**
     * @stability stable
     */
    get enabledFor(): string[];
    /**
     * @stability stable
     */
    set enabledFor(value: string[]);
    /**
     * @stability stable
     */
    resetEnabledFor(): void;
    /**
     * @stability stable
     */
    get enabledForInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
