import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CaptchaConfig extends cdktf.TerraformMetaArguments {
    /**
     * Name of the CAPTCHA.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/captcha.html#name Captcha#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Secret key issued from the CAPTCHA vendor to perform server-side validation for a CAPTCHA token.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/captcha.html#secret_key Captcha#secret_key}
     *
     * @stability stable
     */
    readonly secretKey: string;
    /**
     * Site key issued from the CAPTCHA vendor to render a CAPTCHA on a page.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/captcha.html#site_key Captcha#site_key}
     *
     * @stability stable
     */
    readonly siteKey: string;
    /**
     * Captcha type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/captcha.html#type Captcha#type}
     *
     * @stability stable
     */
    readonly type: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/captcha.html okta_captcha}.
 *
 * @stability stable
 */
export declare class Captcha extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/captcha.html okta_captcha} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: CaptchaConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _secretKey?;
    /**
     * @stability stable
     */
    get secretKey(): string;
    /**
     * @stability stable
     */
    set secretKey(value: string);
    /**
     * @stability stable
     */
    get secretKeyInput(): string | undefined;
    private _siteKey?;
    /**
     * @stability stable
     */
    get siteKey(): string;
    /**
     * @stability stable
     */
    set siteKey(value: string);
    /**
     * @stability stable
     */
    get siteKeyInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
