import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOktaAppGroupAssignmentsConfig extends cdktf.TerraformMetaArguments {
    /**
     * ID of the Okta App being queried for groups.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/app_group_assignments.html#id DataOktaAppGroupAssignments#id}
     *
     * @stability stable
     */
    readonly id: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/d/app_group_assignments.html okta_app_group_assignments}.
 *
 * @stability stable
 */
export declare class DataOktaAppGroupAssignments extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/d/app_group_assignments.html okta_app_group_assignments} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataOktaAppGroupAssignmentsConfig);
    /**
     * @stability stable
     */
    get groups(): string[];
    private _id?;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    set id(value: string);
    /**
     * @stability stable
     */
    get idInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
