import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOktaAppMetadataSamlConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/app_metadata_saml.html#app_id DataOktaAppMetadataSaml#app_id}.
     *
     * @stability stable
     */
    readonly appId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/app_metadata_saml.html#key_id DataOktaAppMetadataSaml#key_id}.
     *
     * @stability stable
     */
    readonly keyId?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/d/app_metadata_saml.html okta_app_metadata_saml}.
 *
 * @stability stable
 */
export declare class DataOktaAppMetadataSaml extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/d/app_metadata_saml.html okta_app_metadata_saml} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataOktaAppMetadataSamlConfig);
    private _appId?;
    /**
     * @stability stable
     */
    get appId(): string;
    /**
     * @stability stable
     */
    set appId(value: string);
    /**
     * @stability stable
     */
    get appIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get certificate(): string;
    /**
     * @stability stable
     */
    get entityId(): string;
    /**
     * @stability stable
     */
    get httpPostBinding(): string;
    /**
     * @stability stable
     */
    get httpRedirectBinding(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _keyId?;
    /**
     * @stability stable
     */
    get keyId(): string;
    /**
     * @stability stable
     */
    set keyId(value: string);
    /**
     * @stability stable
     */
    resetKeyId(): void;
    /**
     * @stability stable
     */
    get keyIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get metadata(): string;
    /**
     * @stability stable
     */
    get wantAuthnRequestsSigned(): any;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
