import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOktaAppOauthConfig extends cdktf.TerraformMetaArguments {
    /**
     * Search only ACTIVE applications.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/app_oauth.html#active_only DataOktaAppOauth#active_only}
     *
     * @stability stable
     */
    readonly activeOnly?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/app_oauth.html#id DataOktaAppOauth#id}.
     *
     * @stability stable
     */
    readonly id?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/app_oauth.html#label DataOktaAppOauth#label}.
     *
     * @stability stable
     */
    readonly label?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/app_oauth.html#label_prefix DataOktaAppOauth#label_prefix}.
     *
     * @stability stable
     */
    readonly labelPrefix?: string;
    /**
     * Ignore groups sync. This is a temporary solution until 'groups' field is supported in all the app-like resources.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/app_oauth.html#skip_groups DataOktaAppOauth#skip_groups}
     *
     * @stability stable
     */
    readonly skipGroups?: boolean | cdktf.IResolvable;
    /**
     * Ignore users sync. This is a temporary solution until 'users' field is supported in all the app-like resources.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/app_oauth.html#skip_users DataOktaAppOauth#skip_users}
     *
     * @stability stable
     */
    readonly skipUsers?: boolean | cdktf.IResolvable;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/d/app_oauth.html okta_app_oauth}.
 *
 * @stability stable
 */
export declare class DataOktaAppOauth extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/d/app_oauth.html okta_app_oauth} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataOktaAppOauthConfig);
    private _activeOnly?;
    /**
     * @stability stable
     */
    get activeOnly(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set activeOnly(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetActiveOnly(): void;
    /**
     * @stability stable
     */
    get activeOnlyInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get autoSubmitToolbar(): any;
    /**
     * @stability stable
     */
    get clientId(): string;
    /**
     * @stability stable
     */
    get clientUri(): string;
    /**
     * @stability stable
     */
    get grantTypes(): string[];
    /**
     * @stability stable
     */
    get groups(): string[];
    /**
     * @stability stable
     */
    get hideIos(): any;
    /**
     * @stability stable
     */
    get hideWeb(): any;
    private _id?;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    set id(value: string);
    /**
     * @stability stable
     */
    resetId(): void;
    /**
     * @stability stable
     */
    get idInput(): string | undefined;
    private _label?;
    /**
     * @stability stable
     */
    get label(): string;
    /**
     * @stability stable
     */
    set label(value: string);
    /**
     * @stability stable
     */
    resetLabel(): void;
    /**
     * @stability stable
     */
    get labelInput(): string | undefined;
    private _labelPrefix?;
    /**
     * @stability stable
     */
    get labelPrefix(): string;
    /**
     * @stability stable
     */
    set labelPrefix(value: string);
    /**
     * @stability stable
     */
    resetLabelPrefix(): void;
    /**
     * @stability stable
     */
    get labelPrefixInput(): string | undefined;
    /**
     * @stability stable
     */
    get links(): string;
    /**
     * @stability stable
     */
    get loginMode(): string;
    /**
     * @stability stable
     */
    get loginScopes(): string[];
    /**
     * @stability stable
     */
    get loginUri(): string;
    /**
     * @stability stable
     */
    get logoUri(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get policyUri(): string;
    /**
     * @stability stable
     */
    get postLogoutRedirectUris(): string[];
    /**
     * @stability stable
     */
    get redirectUris(): string[];
    /**
     * @stability stable
     */
    get responseTypes(): string[];
    private _skipGroups?;
    /**
     * @stability stable
     */
    get skipGroups(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set skipGroups(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSkipGroups(): void;
    /**
     * @stability stable
     */
    get skipGroupsInput(): boolean | cdktf.IResolvable | undefined;
    private _skipUsers?;
    /**
     * @stability stable
     */
    get skipUsers(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set skipUsers(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSkipUsers(): void;
    /**
     * @stability stable
     */
    get skipUsersInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    get users(): string[];
    /**
     * @stability stable
     */
    get wildcardRedirect(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
