import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOktaAppSamlConfig extends cdktf.TerraformMetaArguments {
    /**
     * Search only ACTIVE applications.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/app_saml.html#active_only DataOktaAppSaml#active_only}
     *
     * @stability stable
     */
    readonly activeOnly?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/app_saml.html#id DataOktaAppSaml#id}.
     *
     * @stability stable
     */
    readonly id?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/app_saml.html#label DataOktaAppSaml#label}.
     *
     * @stability stable
     */
    readonly label?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/app_saml.html#label_prefix DataOktaAppSaml#label_prefix}.
     *
     * @stability stable
     */
    readonly labelPrefix?: string;
    /**
     * Denotes whether the request is compressed or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/app_saml.html#request_compressed DataOktaAppSaml#request_compressed}
     *
     * @stability stable
     */
    readonly requestCompressed?: boolean | cdktf.IResolvable;
    /**
     * Ignore groups sync. This is a temporary solution until 'groups' field is supported in all the app-like resources.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/app_saml.html#skip_groups DataOktaAppSaml#skip_groups}
     *
     * @stability stable
     */
    readonly skipGroups?: boolean | cdktf.IResolvable;
    /**
     * Ignore users sync. This is a temporary solution until 'users' field is supported in all the app-like resources.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/app_saml.html#skip_users DataOktaAppSaml#skip_users}
     *
     * @stability stable
     */
    readonly skipUsers?: boolean | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class DataOktaAppSamlAttributeStatements extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get filterType(): string;
    /**
     * @stability stable
     */
    get filterValue(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get namespace(): string;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    get values(): string[];
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/d/app_saml.html okta_app_saml}.
 *
 * @stability stable
 */
export declare class DataOktaAppSaml extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/d/app_saml.html okta_app_saml} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataOktaAppSamlConfig);
    /**
     * @stability stable
     */
    get accessibilityErrorRedirectUrl(): string;
    /**
     * @stability stable
     */
    get accessibilityLoginRedirectUrl(): string;
    /**
     * @stability stable
     */
    get accessibilitySelfService(): any;
    /**
     * @stability stable
     */
    get acsEndpoints(): string[];
    private _activeOnly?;
    /**
     * @stability stable
     */
    get activeOnly(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set activeOnly(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetActiveOnly(): void;
    /**
     * @stability stable
     */
    get activeOnlyInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get appSettingsJson(): string;
    /**
     * @stability stable
     */
    get assertionSigned(): any;
    /**
     * @stability stable
     */
    attributeStatements(index: string): DataOktaAppSamlAttributeStatements;
    /**
     * @stability stable
     */
    get audience(): string;
    /**
     * @stability stable
     */
    get authnContextClassRef(): string;
    /**
     * @stability stable
     */
    get autoSubmitToolbar(): any;
    /**
     * @stability stable
     */
    get defaultRelayState(): string;
    /**
     * @stability stable
     */
    get destination(): string;
    /**
     * @stability stable
     */
    get digestAlgorithm(): string;
    /**
     * @stability stable
     */
    get features(): string[];
    /**
     * @stability stable
     */
    get groups(): string[];
    /**
     * @stability stable
     */
    get hideIos(): any;
    /**
     * @stability stable
     */
    get hideWeb(): any;
    /**
     * @stability stable
     */
    get honorForceAuthn(): any;
    private _id?;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    set id(value: string);
    /**
     * @stability stable
     */
    resetId(): void;
    /**
     * @stability stable
     */
    get idInput(): string | undefined;
    /**
     * @stability stable
     */
    get idpIssuer(): string;
    /**
     * @stability stable
     */
    get inlineHookId(): string;
    /**
     * @stability stable
     */
    get keyId(): string;
    private _label?;
    /**
     * @stability stable
     */
    get label(): string;
    /**
     * @stability stable
     */
    set label(value: string);
    /**
     * @stability stable
     */
    resetLabel(): void;
    /**
     * @stability stable
     */
    get labelInput(): string | undefined;
    private _labelPrefix?;
    /**
     * @stability stable
     */
    get labelPrefix(): string;
    /**
     * @stability stable
     */
    set labelPrefix(value: string);
    /**
     * @stability stable
     */
    resetLabelPrefix(): void;
    /**
     * @stability stable
     */
    get labelPrefixInput(): string | undefined;
    /**
     * @stability stable
     */
    get links(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get recipient(): string;
    private _requestCompressed?;
    /**
     * @stability stable
     */
    get requestCompressed(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set requestCompressed(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRequestCompressed(): void;
    /**
     * @stability stable
     */
    get requestCompressedInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get responseSigned(): any;
    /**
     * @stability stable
     */
    get signatureAlgorithm(): string;
    /**
     * @stability stable
     */
    get singleLogoutCertificate(): string;
    /**
     * @stability stable
     */
    get singleLogoutIssuer(): string;
    /**
     * @stability stable
     */
    get singleLogoutUrl(): string;
    private _skipGroups?;
    /**
     * @stability stable
     */
    get skipGroups(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set skipGroups(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSkipGroups(): void;
    /**
     * @stability stable
     */
    get skipGroupsInput(): boolean | cdktf.IResolvable | undefined;
    private _skipUsers?;
    /**
     * @stability stable
     */
    get skipUsers(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set skipUsers(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSkipUsers(): void;
    /**
     * @stability stable
     */
    get skipUsersInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get spIssuer(): string;
    /**
     * @stability stable
     */
    get ssoUrl(): string;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    get subjectNameIdFormat(): string;
    /**
     * @stability stable
     */
    get subjectNameIdTemplate(): string;
    /**
     * @stability stable
     */
    get userNameTemplate(): string;
    /**
     * @stability stable
     */
    get userNameTemplatePushStatus(): string;
    /**
     * @stability stable
     */
    get userNameTemplateSuffix(): string;
    /**
     * @stability stable
     */
    get userNameTemplateType(): string;
    /**
     * @stability stable
     */
    get users(): string[];
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
