import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOktaAppSignonPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * App ID.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/app_signon_policy.html#app_id DataOktaAppSignonPolicy#app_id}
     *
     * @stability stable
     */
    readonly appId: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/d/app_signon_policy.html okta_app_signon_policy}.
 *
 * @stability stable
 */
export declare class DataOktaAppSignonPolicy extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/d/app_signon_policy.html okta_app_signon_policy} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataOktaAppSignonPolicyConfig);
    private _appId?;
    /**
     * @stability stable
     */
    get appId(): string;
    /**
     * @stability stable
     */
    set appId(value: string);
    /**
     * @stability stable
     */
    get appIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
