import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOktaAppUserAssignmentsConfig extends cdktf.TerraformMetaArguments {
    /**
     * ID of the Okta App being queried for groups.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/app_user_assignments.html#id DataOktaAppUserAssignments#id}
     *
     * @stability stable
     */
    readonly id: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/d/app_user_assignments.html okta_app_user_assignments}.
 *
 * @stability stable
 */
export declare class DataOktaAppUserAssignments extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/d/app_user_assignments.html okta_app_user_assignments} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataOktaAppUserAssignmentsConfig);
    private _id?;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    set id(value: string);
    /**
     * @stability stable
     */
    get idInput(): string | undefined;
    /**
     * @stability stable
     */
    get users(): string[];
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
