import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOktaAuthServerClaimConfig extends cdktf.TerraformMetaArguments {
    /**
     * Auth server ID.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/auth_server_claim.html#auth_server_id DataOktaAuthServerClaim#auth_server_id}
     *
     * @stability stable
     */
    readonly authServerId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/auth_server_claim.html#id DataOktaAuthServerClaim#id}.
     *
     * @stability stable
     */
    readonly id?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/auth_server_claim.html#name DataOktaAuthServerClaim#name}.
     *
     * @stability stable
     */
    readonly name?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/d/auth_server_claim.html okta_auth_server_claim}.
 *
 * @stability stable
 */
export declare class DataOktaAuthServerClaim extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/d/auth_server_claim.html okta_auth_server_claim} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataOktaAuthServerClaimConfig);
    /**
     * @stability stable
     */
    get alwaysIncludeInToken(): any;
    private _authServerId?;
    /**
     * @stability stable
     */
    get authServerId(): string;
    /**
     * @stability stable
     */
    set authServerId(value: string);
    /**
     * @stability stable
     */
    get authServerIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get claimType(): string;
    private _id?;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    set id(value: string);
    /**
     * @stability stable
     */
    resetId(): void;
    /**
     * @stability stable
     */
    get idInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get scopes(): string[];
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    get value(): string;
    /**
     * @stability stable
     */
    get valueType(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
