import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOktaAuthServerClaimsConfig extends cdktf.TerraformMetaArguments {
    /**
     * Auth server ID.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/auth_server_claims.html#auth_server_id DataOktaAuthServerClaims#auth_server_id}
     *
     * @stability stable
     */
    readonly authServerId: string;
}
/**
 * @stability stable
 */
export declare class DataOktaAuthServerClaimsClaims extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get alwaysIncludeInToken(): any;
    /**
     * @stability stable
     */
    get claimType(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get scopes(): string[];
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    get value(): string;
    /**
     * @stability stable
     */
    get valueType(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/d/auth_server_claims.html okta_auth_server_claims}.
 *
 * @stability stable
 */
export declare class DataOktaAuthServerClaims extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/d/auth_server_claims.html okta_auth_server_claims} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataOktaAuthServerClaimsConfig);
    private _authServerId?;
    /**
     * @stability stable
     */
    get authServerId(): string;
    /**
     * @stability stable
     */
    set authServerId(value: string);
    /**
     * @stability stable
     */
    get authServerIdInput(): string | undefined;
    /**
     * @stability stable
     */
    claims(index: string): DataOktaAuthServerClaimsClaims;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
