import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOktaAuthServerPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Auth server ID.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/auth_server_policy.html#auth_server_id DataOktaAuthServerPolicy#auth_server_id}
     *
     * @stability stable
     */
    readonly authServerId: string;
    /**
     * Name of the policy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/auth_server_policy.html#name DataOktaAuthServerPolicy#name}
     *
     * @stability stable
     */
    readonly name: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/d/auth_server_policy.html okta_auth_server_policy}.
 *
 * @stability stable
 */
export declare class DataOktaAuthServerPolicy extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/d/auth_server_policy.html okta_auth_server_policy} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataOktaAuthServerPolicyConfig);
    /**
     * @stability stable
     */
    get assignedClients(): string[];
    private _authServerId?;
    /**
     * @stability stable
     */
    get authServerId(): string;
    /**
     * @stability stable
     */
    set authServerId(value: string);
    /**
     * @stability stable
     */
    get authServerIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
