import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOktaAuthServerScopesConfig extends cdktf.TerraformMetaArguments {
    /**
     * Auth server ID.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/auth_server_scopes.html#auth_server_id DataOktaAuthServerScopes#auth_server_id}
     *
     * @stability stable
     */
    readonly authServerId: string;
}
/**
 * @stability stable
 */
export declare class DataOktaAuthServerScopesScopes extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get consent(): string;
    /**
     * @stability stable
     */
    get default(): any;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get metadataPublish(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get systemAttribute(): any;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/d/auth_server_scopes.html okta_auth_server_scopes}.
 *
 * @stability stable
 */
export declare class DataOktaAuthServerScopes extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/d/auth_server_scopes.html okta_auth_server_scopes} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataOktaAuthServerScopesConfig);
    private _authServerId?;
    /**
     * @stability stable
     */
    get authServerId(): string;
    /**
     * @stability stable
     */
    set authServerId(value: string);
    /**
     * @stability stable
     */
    get authServerIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    scopes(index: string): DataOktaAuthServerScopesScopes;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
