import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOktaAuthServerConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/auth_server.html#name DataOktaAuthServer#name}.
     *
     * @stability stable
     */
    readonly name: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/d/auth_server.html okta_auth_server}.
 *
 * @stability stable
 */
export declare class DataOktaAuthServer extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/d/auth_server.html okta_auth_server} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataOktaAuthServerConfig);
    /**
     * @stability stable
     */
    get audiences(): string[];
    /**
     * @stability stable
     */
    get credentialsLastRotated(): string;
    /**
     * @stability stable
     */
    get credentialsNextRotation(): string;
    /**
     * @stability stable
     */
    get credentialsRotationMode(): string;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get issuer(): string;
    /**
     * @stability stable
     */
    get issuerMode(): string;
    /**
     * @stability stable
     */
    get kid(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
