import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOktaAuthenticatorConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/authenticator.html#id DataOktaAuthenticator#id}.
     *
     * @stability stable
     */
    readonly id?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/authenticator.html#key DataOktaAuthenticator#key}.
     *
     * @stability stable
     */
    readonly key?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/authenticator.html#name DataOktaAuthenticator#name}.
     *
     * @stability stable
     */
    readonly name?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/d/authenticator.html okta_authenticator}.
 *
 * @stability stable
 */
export declare class DataOktaAuthenticator extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/d/authenticator.html okta_authenticator} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataOktaAuthenticatorConfig);
    private _id?;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    set id(value: string);
    /**
     * @stability stable
     */
    resetId(): void;
    /**
     * @stability stable
     */
    get idInput(): string | undefined;
    private _key?;
    /**
     * @stability stable
     */
    get key(): string;
    /**
     * @stability stable
     */
    set key(value: string);
    /**
     * @stability stable
     */
    resetKey(): void;
    /**
     * @stability stable
     */
    get keyInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get providerAuthPort(): number;
    /**
     * @stability stable
     */
    get providerHostname(): string;
    /**
     * @stability stable
     */
    get providerInstanceId(): string;
    /**
     * @stability stable
     */
    get providerType(): string;
    /**
     * @stability stable
     */
    get providerUserNameTemplate(): string;
    /**
     * @stability stable
     */
    get settings(): string;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
