import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOktaBehaviorConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/behavior.html#id DataOktaBehavior#id}.
     *
     * @stability stable
     */
    readonly id?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/behavior.html#name DataOktaBehavior#name}.
     *
     * @stability stable
     */
    readonly name?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/d/behavior.html okta_behavior}.
 *
 * @stability stable
 */
export declare class DataOktaBehavior extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/d/behavior.html okta_behavior} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataOktaBehaviorConfig);
    private _id?;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    set id(value: string);
    /**
     * @stability stable
     */
    resetId(): void;
    /**
     * @stability stable
     */
    get idInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    settings(key: string): string;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
