import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOktaBehaviorsConfig extends cdktf.TerraformMetaArguments {
    /**
     * Searches the name property of behaviors for matching value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/behaviors.html#q DataOktaBehaviors#q}
     *
     * @stability stable
     */
    readonly q?: string;
}
/**
 * @stability stable
 */
export declare class DataOktaBehaviorsBehaviors extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get settings(): any;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/d/behaviors.html okta_behaviors}.
 *
 * @stability stable
 */
export declare class DataOktaBehaviors extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/d/behaviors.html okta_behaviors} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataOktaBehaviorsConfig);
    /**
     * @stability stable
     */
    behaviors(index: string): DataOktaBehaviorsBehaviors;
    /**
     * @stability stable
     */
    get id(): string;
    private _q?;
    /**
     * @stability stable
     */
    get q(): string;
    /**
     * @stability stable
     */
    set q(value: string);
    /**
     * @stability stable
     */
    resetQ(): void;
    /**
     * @stability stable
     */
    get qInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
