import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOktaDefaultPoliciesConfig extends cdktf.TerraformMetaArguments {
    /**
     * Policy type: OKTA_SIGN_ON, PASSWORD, MFA_ENROLL, or IDP_DISCOVERY.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/default_policies.html#type DataOktaDefaultPolicies#type}
     *
     * @stability stable
     */
    readonly type: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/d/default_policies.html okta_default_policies}.
 *
 * @stability stable
 */
export declare class DataOktaDefaultPolicies extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/d/default_policies.html okta_default_policies} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataOktaDefaultPoliciesConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
