import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOktaEveryoneGroupConfig extends cdktf.TerraformMetaArguments {
    /**
     * Fetch group users, having default off cuts down on API calls.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/everyone_group.html#include_users DataOktaEveryoneGroup#include_users}
     *
     * @stability stable
     */
    readonly includeUsers?: boolean | cdktf.IResolvable;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/d/everyone_group.html okta_everyone_group}.
 *
 * @stability stable
 */
export declare class DataOktaEveryoneGroup extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/d/everyone_group.html okta_everyone_group} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataOktaEveryoneGroupConfig);
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _includeUsers?;
    /**
     * @stability stable
     */
    get includeUsers(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set includeUsers(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIncludeUsers(): void;
    /**
     * @stability stable
     */
    get includeUsersInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
