import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOktaGroupConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/group.html#id DataOktaGroup#id}.
     *
     * @stability stable
     */
    readonly id?: string;
    /**
     * Fetch group users, having default off cuts down on API calls.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/group.html#include_users DataOktaGroup#include_users}
     *
     * @stability stable
     */
    readonly includeUsers?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/group.html#name DataOktaGroup#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Type of the group.
     *
     * When specified in the terraform resource, will act as a filter when searching for the group
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/group.html#type DataOktaGroup#type}
     *
     * @stability stable
     */
    readonly type?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/d/group.html okta_group}.
 *
 * @stability stable
 */
export declare class DataOktaGroup extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/d/group.html okta_group} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataOktaGroupConfig);
    /**
     * @stability stable
     */
    get description(): string;
    private _id?;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    set id(value: string);
    /**
     * @stability stable
     */
    resetId(): void;
    /**
     * @stability stable
     */
    get idInput(): string | undefined;
    private _includeUsers?;
    /**
     * @stability stable
     */
    get includeUsers(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set includeUsers(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIncludeUsers(): void;
    /**
     * @stability stable
     */
    get includeUsersInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    resetType(): void;
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    /**
     * @stability stable
     */
    get users(): string[];
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
