import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOktaGroupsConfig extends cdktf.TerraformMetaArguments {
    /**
     * Searches the name property of groups for matching value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/groups.html#q DataOktaGroups#q}
     *
     * @stability stable
     */
    readonly q?: string;
    /**
     * Searches for groups with a supported filtering expression for all attributes except for '_embedded', '_links', and 'objectClass'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/groups.html#search DataOktaGroups#search}
     *
     * @stability stable
     */
    readonly search?: string;
    /**
     * Type of the group.
     *
     * When specified in the terraform resource, will act as a filter when searching for the groups
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/groups.html#type DataOktaGroups#type}
     *
     * @stability stable
     */
    readonly type?: string;
}
/**
 * @stability stable
 */
export declare class DataOktaGroupsGroups extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/d/groups.html okta_groups}.
 *
 * @stability stable
 */
export declare class DataOktaGroups extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/d/groups.html okta_groups} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataOktaGroupsConfig);
    /**
     * @stability stable
     */
    groups(index: string): DataOktaGroupsGroups;
    /**
     * @stability stable
     */
    get id(): string;
    private _q?;
    /**
     * @stability stable
     */
    get q(): string;
    /**
     * @stability stable
     */
    set q(value: string);
    /**
     * @stability stable
     */
    resetQ(): void;
    /**
     * @stability stable
     */
    get qInput(): string | undefined;
    private _search?;
    /**
     * @stability stable
     */
    get search(): string;
    /**
     * @stability stable
     */
    set search(value: string);
    /**
     * @stability stable
     */
    resetSearch(): void;
    /**
     * @stability stable
     */
    get searchInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    resetType(): void;
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
