import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOktaIdpMetadataSamlConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/idp_metadata_saml.html#idp_id DataOktaIdpMetadataSaml#idp_id}.
     *
     * @stability stable
     */
    readonly idpId?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/d/idp_metadata_saml.html okta_idp_metadata_saml}.
 *
 * @stability stable
 */
export declare class DataOktaIdpMetadataSaml extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/d/idp_metadata_saml.html okta_idp_metadata_saml} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataOktaIdpMetadataSamlConfig);
    /**
     * @stability stable
     */
    get assertionsSigned(): any;
    /**
     * @stability stable
     */
    get authnRequestSigned(): any;
    /**
     * @stability stable
     */
    get encryptionCertificate(): string;
    /**
     * @stability stable
     */
    get entityId(): string;
    /**
     * @stability stable
     */
    get httpPostBinding(): string;
    /**
     * @stability stable
     */
    get httpRedirectBinding(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _idpId?;
    /**
     * @stability stable
     */
    get idpId(): string;
    /**
     * @stability stable
     */
    set idpId(value: string);
    /**
     * @stability stable
     */
    resetIdpId(): void;
    /**
     * @stability stable
     */
    get idpIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get metadata(): string;
    /**
     * @stability stable
     */
    get signingCertificate(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
