import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOktaIdpOidcConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/idp_oidc.html#id DataOktaIdpOidc#id}.
     *
     * @stability stable
     */
    readonly id?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/idp_oidc.html#name DataOktaIdpOidc#name}.
     *
     * @stability stable
     */
    readonly name?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/d/idp_oidc.html okta_idp_oidc}.
 *
 * @stability stable
 */
export declare class DataOktaIdpOidc extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/d/idp_oidc.html okta_idp_oidc} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataOktaIdpOidcConfig);
    /**
     * @stability stable
     */
    get authorizationBinding(): string;
    /**
     * @stability stable
     */
    get authorizationUrl(): string;
    /**
     * @stability stable
     */
    get clientId(): string;
    /**
     * @stability stable
     */
    get clientSecret(): string;
    private _id?;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    set id(value: string);
    /**
     * @stability stable
     */
    resetId(): void;
    /**
     * @stability stable
     */
    get idInput(): string | undefined;
    /**
     * @stability stable
     */
    get issuerMode(): string;
    /**
     * @stability stable
     */
    get issuerUrl(): string;
    /**
     * @stability stable
     */
    get jwksBinding(): string;
    /**
     * @stability stable
     */
    get jwksUrl(): string;
    /**
     * @stability stable
     */
    get maxClockSkew(): number;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get protocolType(): string;
    /**
     * @stability stable
     */
    get scopes(): string[];
    /**
     * @stability stable
     */
    get tokenBinding(): string;
    /**
     * @stability stable
     */
    get tokenUrl(): string;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    get userInfoBinding(): string;
    /**
     * @stability stable
     */
    get userInfoUrl(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
