import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOktaIdpSamlConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/idp_saml.html#id DataOktaIdpSaml#id}.
     *
     * @stability stable
     */
    readonly id?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/idp_saml.html#name DataOktaIdpSaml#name}.
     *
     * @stability stable
     */
    readonly name?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/d/idp_saml.html okta_idp_saml}.
 *
 * @stability stable
 */
export declare class DataOktaIdpSaml extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/d/idp_saml.html okta_idp_saml} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataOktaIdpSamlConfig);
    /**
     * @stability stable
     */
    get acsBinding(): string;
    /**
     * @stability stable
     */
    get acsType(): string;
    /**
     * @stability stable
     */
    get audience(): string;
    private _id?;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    set id(value: string);
    /**
     * @stability stable
     */
    resetId(): void;
    /**
     * @stability stable
     */
    get idInput(): string | undefined;
    /**
     * @stability stable
     */
    get issuer(): string;
    /**
     * @stability stable
     */
    get issuerMode(): string;
    /**
     * @stability stable
     */
    get kid(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get ssoBinding(): string;
    /**
     * @stability stable
     */
    get ssoDestination(): string;
    /**
     * @stability stable
     */
    get ssoUrl(): string;
    /**
     * @stability stable
     */
    get subjectFilter(): string;
    /**
     * @stability stable
     */
    get subjectFormat(): string[];
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
