import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOktaIdpSocialConfig extends cdktf.TerraformMetaArguments {
    /**
     * ID of the IdP.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/idp_social.html#id DataOktaIdpSocial#id}
     *
     * @stability stable
     */
    readonly id?: string;
    /**
     * name of the IdP.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/idp_social.html#name DataOktaIdpSocial#name}
     *
     * @stability stable
     */
    readonly name?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/d/idp_social.html okta_idp_social}.
 *
 * @stability stable
 */
export declare class DataOktaIdpSocial extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/d/idp_social.html okta_idp_social} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataOktaIdpSocialConfig);
    /**
     * @stability stable
     */
    get accountLinkAction(): string;
    /**
     * @stability stable
     */
    get accountLinkGroupInclude(): string[];
    /**
     * @stability stable
     */
    get authorizationBinding(): string;
    /**
     * @stability stable
     */
    get authorizationUrl(): string;
    /**
     * @stability stable
     */
    get clientId(): string;
    /**
     * @stability stable
     */
    get clientSecret(): string;
    /**
     * @stability stable
     */
    get deprovisionedAction(): string;
    /**
     * @stability stable
     */
    get groupsAction(): string;
    /**
     * @stability stable
     */
    get groupsAssignment(): string[];
    /**
     * @stability stable
     */
    get groupsAttribute(): string;
    /**
     * @stability stable
     */
    get groupsFilter(): string[];
    private _id?;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    set id(value: string);
    /**
     * @stability stable
     */
    resetId(): void;
    /**
     * @stability stable
     */
    get idInput(): string | undefined;
    /**
     * @stability stable
     */
    get issuerMode(): string;
    /**
     * @stability stable
     */
    get maxClockSkew(): number;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get profileMaster(): any;
    /**
     * @stability stable
     */
    get protocolType(): string;
    /**
     * @stability stable
     */
    get provisioningAction(): string;
    /**
     * @stability stable
     */
    get scopes(): string[];
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    get subjectMatchAttribute(): string;
    /**
     * @stability stable
     */
    get subjectMatchType(): string;
    /**
     * @stability stable
     */
    get suspendedAction(): string;
    /**
     * @stability stable
     */
    get tokenBinding(): string;
    /**
     * @stability stable
     */
    get tokenUrl(): string;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    get usernameTemplate(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
