import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOktaNetworkZoneConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/network_zone.html#id DataOktaNetworkZone#id}.
     *
     * @stability stable
     */
    readonly id?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/network_zone.html#name DataOktaNetworkZone#name}.
     *
     * @stability stable
     */
    readonly name?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/d/network_zone.html okta_network_zone}.
 *
 * @stability stable
 */
export declare class DataOktaNetworkZone extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/d/network_zone.html okta_network_zone} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataOktaNetworkZoneConfig);
    /**
     * @stability stable
     */
    get asns(): string[];
    /**
     * @stability stable
     */
    get dynamicLocations(): string[];
    /**
     * @stability stable
     */
    get dynamicProxyType(): string;
    /**
     * @stability stable
     */
    get gateways(): string[];
    private _id?;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    set id(value: string);
    /**
     * @stability stable
     */
    resetId(): void;
    /**
     * @stability stable
     */
    get idInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get proxies(): string[];
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    get usage(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
