import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOktaPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Name of the policy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/policy.html#name DataOktaPolicy#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Policy type: OKTA_SIGN_ON, PASSWORD, MFA_ENROLL, or IDP_DISCOVERY.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/policy.html#type DataOktaPolicy#type}
     *
     * @stability stable
     */
    readonly type: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/d/policy.html okta_policy}.
 *
 * @stability stable
 */
export declare class DataOktaPolicy extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/d/policy.html okta_policy} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataOktaPolicyConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get status(): string;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
