import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOktaRoleSubscriptionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Type of the notification.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/role_subscription.html#notification_type DataOktaRoleSubscription#notification_type}
     *
     * @stability stable
     */
    readonly notificationType: string;
    /**
     * Type of the role.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/role_subscription.html#role_type DataOktaRoleSubscription#role_type}
     *
     * @stability stable
     */
    readonly roleType: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/d/role_subscription.html okta_role_subscription}.
 *
 * @stability stable
 */
export declare class DataOktaRoleSubscription extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/d/role_subscription.html okta_role_subscription} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataOktaRoleSubscriptionConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _notificationType?;
    /**
     * @stability stable
     */
    get notificationType(): string;
    /**
     * @stability stable
     */
    set notificationType(value: string);
    /**
     * @stability stable
     */
    get notificationTypeInput(): string | undefined;
    private _roleType?;
    /**
     * @stability stable
     */
    get roleType(): string;
    /**
     * @stability stable
     */
    set roleType(value: string);
    /**
     * @stability stable
     */
    get roleTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
