import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOktaTrustedOriginsConfig extends cdktf.TerraformMetaArguments {
    /**
     * Filter criteria. Filter value will be URL-encoded by the provider.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/trusted_origins.html#filter DataOktaTrustedOrigins#filter}
     *
     * @stability stable
     */
    readonly filter?: string;
}
/**
 * @stability stable
 */
export declare class DataOktaTrustedOriginsTrustedOrigins extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get active(): any;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get origin(): string;
    /**
     * @stability stable
     */
    get scopes(): string[];
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/d/trusted_origins.html okta_trusted_origins}.
 *
 * @stability stable
 */
export declare class DataOktaTrustedOrigins extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/d/trusted_origins.html okta_trusted_origins} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataOktaTrustedOriginsConfig);
    private _filter?;
    /**
     * @stability stable
     */
    get filter(): string;
    /**
     * @stability stable
     */
    set filter(value: string);
    /**
     * @stability stable
     */
    resetFilter(): void;
    /**
     * @stability stable
     */
    get filterInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    trustedOrigins(index: string): DataOktaTrustedOriginsTrustedOrigins;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
