import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOktaUserSecurityQuestionsConfig extends cdktf.TerraformMetaArguments {
    /**
     * ID of a Okta User.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/user_security_questions.html#user_id DataOktaUserSecurityQuestions#user_id}
     *
     * @stability stable
     */
    readonly userId: string;
}
/**
 * @stability stable
 */
export declare class DataOktaUserSecurityQuestionsQuestions extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get key(): string;
    /**
     * @stability stable
     */
    get text(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/d/user_security_questions.html okta_user_security_questions}.
 *
 * @stability stable
 */
export declare class DataOktaUserSecurityQuestions extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/d/user_security_questions.html okta_user_security_questions} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataOktaUserSecurityQuestionsConfig);
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    questions(index: string): DataOktaUserSecurityQuestionsQuestions;
    private _userId?;
    /**
     * @stability stable
     */
    get userId(): string;
    /**
     * @stability stable
     */
    set userId(value: string);
    /**
     * @stability stable
     */
    get userIdInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
