import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOktaUserConfig extends cdktf.TerraformMetaArguments {
    /**
     * Retrieve a single user based on their id.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/user.html#user_id DataOktaUser#user_id}
     *
     * @stability stable
     */
    readonly userId?: string;
    /**
     * search block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/user.html#search DataOktaUser#search}
     *
     * @stability stable
     */
    readonly search?: DataOktaUserSearch[];
}
/**
 * @stability stable
 */
export interface DataOktaUserSearch {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/user.html#comparison DataOktaUser#comparison}.
     *
     * @stability stable
     */
    readonly comparison?: string;
    /**
     * Property name to search for.
     *
     * This requires the search feature be on. Please see Okta documentation on their filter API for users. https://developer.okta.com/docs/api/resources/users#list-users-with-search
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/user.html#name DataOktaUser#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/user.html#value DataOktaUser#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function dataOktaUserSearchToTerraform(struct?: DataOktaUserSearch): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/d/user.html okta_user}.
 *
 * @stability stable
 */
export declare class DataOktaUser extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/d/user.html okta_user} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataOktaUserConfig);
    /**
     * @stability stable
     */
    get adminRoles(): string[];
    /**
     * @stability stable
     */
    get city(): string;
    /**
     * @stability stable
     */
    get costCenter(): string;
    /**
     * @stability stable
     */
    get countryCode(): string;
    /**
     * @stability stable
     */
    get customProfileAttributes(): string;
    /**
     * @stability stable
     */
    get department(): string;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    get division(): string;
    /**
     * @stability stable
     */
    get email(): string;
    /**
     * @stability stable
     */
    get employeeNumber(): string;
    /**
     * @stability stable
     */
    get firstName(): string;
    /**
     * @stability stable
     */
    get groupMemberships(): string[];
    /**
     * @stability stable
     */
    get honorificPrefix(): string;
    /**
     * @stability stable
     */
    get honorificSuffix(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get lastName(): string;
    /**
     * @stability stable
     */
    get locale(): string;
    /**
     * @stability stable
     */
    get login(): string;
    /**
     * @stability stable
     */
    get manager(): string;
    /**
     * @stability stable
     */
    get managerId(): string;
    /**
     * @stability stable
     */
    get middleName(): string;
    /**
     * @stability stable
     */
    get mobilePhone(): string;
    /**
     * @stability stable
     */
    get nickName(): string;
    /**
     * @stability stable
     */
    get organization(): string;
    /**
     * @stability stable
     */
    get postalAddress(): string;
    /**
     * @stability stable
     */
    get preferredLanguage(): string;
    /**
     * @stability stable
     */
    get primaryPhone(): string;
    /**
     * @stability stable
     */
    get profileUrl(): string;
    /**
     * @stability stable
     */
    get secondEmail(): string;
    /**
     * @stability stable
     */
    get state(): string;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    get streetAddress(): string;
    /**
     * @stability stable
     */
    get timezone(): string;
    /**
     * @stability stable
     */
    get title(): string;
    private _userId?;
    /**
     * @stability stable
     */
    get userId(): string;
    /**
     * @stability stable
     */
    set userId(value: string);
    /**
     * @stability stable
     */
    resetUserId(): void;
    /**
     * @stability stable
     */
    get userIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get userType(): string;
    /**
     * @stability stable
     */
    get zipCode(): string;
    private _search?;
    /**
     * @stability stable
     */
    get search(): DataOktaUserSearch[];
    /**
     * @stability stable
     */
    set search(value: DataOktaUserSearch[]);
    /**
     * @stability stable
     */
    resetSearch(): void;
    /**
     * @stability stable
     */
    get searchInput(): DataOktaUserSearch[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
