import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOktaUsersConfig extends cdktf.TerraformMetaArguments {
    /**
     * search block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/users.html#search DataOktaUsers#search}
     *
     * @stability stable
     */
    readonly search: DataOktaUsersSearch[];
}
/**
 * @stability stable
 */
export declare class DataOktaUsersUsers extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get adminRoles(): string[];
    /**
     * @stability stable
     */
    get city(): string;
    /**
     * @stability stable
     */
    get costCenter(): string;
    /**
     * @stability stable
     */
    get countryCode(): string;
    /**
     * @stability stable
     */
    get customProfileAttributes(): string;
    /**
     * @stability stable
     */
    get department(): string;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    get division(): string;
    /**
     * @stability stable
     */
    get email(): string;
    /**
     * @stability stable
     */
    get employeeNumber(): string;
    /**
     * @stability stable
     */
    get firstName(): string;
    /**
     * @stability stable
     */
    get groupMemberships(): string[];
    /**
     * @stability stable
     */
    get honorificPrefix(): string;
    /**
     * @stability stable
     */
    get honorificSuffix(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get lastName(): string;
    /**
     * @stability stable
     */
    get locale(): string;
    /**
     * @stability stable
     */
    get login(): string;
    /**
     * @stability stable
     */
    get manager(): string;
    /**
     * @stability stable
     */
    get managerId(): string;
    /**
     * @stability stable
     */
    get middleName(): string;
    /**
     * @stability stable
     */
    get mobilePhone(): string;
    /**
     * @stability stable
     */
    get nickName(): string;
    /**
     * @stability stable
     */
    get organization(): string;
    /**
     * @stability stable
     */
    get postalAddress(): string;
    /**
     * @stability stable
     */
    get preferredLanguage(): string;
    /**
     * @stability stable
     */
    get primaryPhone(): string;
    /**
     * @stability stable
     */
    get profileUrl(): string;
    /**
     * @stability stable
     */
    get secondEmail(): string;
    /**
     * @stability stable
     */
    get state(): string;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    get streetAddress(): string;
    /**
     * @stability stable
     */
    get timezone(): string;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    get userType(): string;
    /**
     * @stability stable
     */
    get zipCode(): string;
}
/**
 * @stability stable
 */
export interface DataOktaUsersSearch {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/users.html#comparison DataOktaUsers#comparison}.
     *
     * @stability stable
     */
    readonly comparison?: string;
    /**
     * Property name to search for.
     *
     * This requires the search feature be on. Please see Okta documentation on their filter API for users. https://developer.okta.com/docs/api/resources/users#list-users-with-search
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/users.html#name DataOktaUsers#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/users.html#value DataOktaUsers#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function dataOktaUsersSearchToTerraform(struct?: DataOktaUsersSearch): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/d/users.html okta_users}.
 *
 * @stability stable
 */
export declare class DataOktaUsers extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/d/users.html okta_users} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataOktaUsersConfig);
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    users(index: string): DataOktaUsersUsers;
    private _search?;
    /**
     * @stability stable
     */
    get search(): DataOktaUsersSearch[];
    /**
     * @stability stable
     */
    set search(value: DataOktaUsersSearch[]);
    /**
     * @stability stable
     */
    get searchInput(): DataOktaUsersSearch[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
