import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DomainCertificateConfig extends cdktf.TerraformMetaArguments {
    /**
     * Certificate content.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/domain_certificate.html#certificate DomainCertificate#certificate}
     *
     * @stability stable
     */
    readonly certificate: string;
    /**
     * Certificate chain.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/domain_certificate.html#certificate_chain DomainCertificate#certificate_chain}
     *
     * @stability stable
     */
    readonly certificateChain: string;
    /**
     * Domain's ID.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/domain_certificate.html#domain_id DomainCertificate#domain_id}
     *
     * @stability stable
     */
    readonly domainId: string;
    /**
     * Certificate private key.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/domain_certificate.html#private_key DomainCertificate#private_key}
     *
     * @stability stable
     */
    readonly privateKey: string;
    /**
     * Certificate type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/domain_certificate.html#type DomainCertificate#type}
     *
     * @stability stable
     */
    readonly type?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/domain_certificate.html okta_domain_certificate}.
 *
 * @stability stable
 */
export declare class DomainCertificate extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/domain_certificate.html okta_domain_certificate} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DomainCertificateConfig);
    private _certificate?;
    /**
     * @stability stable
     */
    get certificate(): string;
    /**
     * @stability stable
     */
    set certificate(value: string);
    /**
     * @stability stable
     */
    get certificateInput(): string | undefined;
    private _certificateChain?;
    /**
     * @stability stable
     */
    get certificateChain(): string;
    /**
     * @stability stable
     */
    set certificateChain(value: string);
    /**
     * @stability stable
     */
    get certificateChainInput(): string | undefined;
    private _domainId?;
    /**
     * @stability stable
     */
    get domainId(): string;
    /**
     * @stability stable
     */
    set domainId(value: string);
    /**
     * @stability stable
     */
    get domainIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _privateKey?;
    /**
     * @stability stable
     */
    get privateKey(): string;
    /**
     * @stability stable
     */
    set privateKey(value: string);
    /**
     * @stability stable
     */
    get privateKeyInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    resetType(): void;
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
