import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DomainVerificationConfig extends cdktf.TerraformMetaArguments {
    /**
     * Domain's ID.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/domain_verification.html#domain_id DomainVerification#domain_id}
     *
     * @stability stable
     */
    readonly domainId: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/domain_verification.html okta_domain_verification}.
 *
 * @stability stable
 */
export declare class DomainVerification extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/domain_verification.html okta_domain_verification} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DomainVerificationConfig);
    private _domainId?;
    /**
     * @stability stable
     */
    get domainId(): string;
    /**
     * @stability stable
     */
    set domainId(value: string);
    /**
     * @stability stable
     */
    get domainIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
