import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DomainConfig extends cdktf.TerraformMetaArguments {
    /**
     * Custom Domain name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/domain.html#name Domain#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Indicates whether the domain should be verified during creation.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/domain.html#verify Domain#verify}
     *
     * @stability stable
     */
    readonly verify?: boolean | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class DomainDnsRecords extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get expiration(): string;
    /**
     * @stability stable
     */
    get fqdn(): string;
    /**
     * @stability stable
     */
    get recordType(): string;
    /**
     * @stability stable
     */
    get values(): string[];
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/domain.html okta_domain}.
 *
 * @stability stable
 */
export declare class Domain extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/domain.html okta_domain} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DomainConfig);
    /**
     * @stability stable
     */
    dnsRecords(index: string): DomainDnsRecords;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get validationStatus(): string;
    private _verify?;
    /**
     * @stability stable
     */
    get verify(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set verify(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetVerify(): void;
    /**
     * @stability stable
     */
    get verifyInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
